/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.utils.XmlSerializable;
import org.apache.plc4x.java.spi.values.PlcValueAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcStruct
extends PlcValueAdapter {
    private final Map<String, PlcValue> map;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcStruct(@JsonProperty(value="map") Map<String, PlcValue> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return 1;
    }

    @Override
    @JsonIgnore
    public boolean isStruct() {
        return true;
    }

    @Override
    @JsonIgnore
    public Set<String> getKeys() {
        return this.map.keySet();
    }

    @Override
    @JsonIgnore
    public boolean hasKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    @JsonIgnore
    public PlcValue getValue(String key) {
        return this.map.get(key);
    }

    @Override
    @JsonIgnore
    public Map<String, ? extends PlcValue> getStruct() {
        return this.map;
    }

    @JsonIgnore
    public String toString() {
        return "{" + this.map.entrySet().stream().map(entry -> String.format("\"%s\": %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(",")) + "}";
    }

    @Override
    public void xmlSerialize(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element plcValueElement = doc.createElement("PlcStruct");
        parent.appendChild(plcValueElement);
        for (Map.Entry<String, PlcValue> entry : this.map.entrySet()) {
            String fieldName = entry.getKey();
            Element fieldElement = doc.createElement(fieldName);
            plcValueElement.appendChild(fieldElement);
            PlcValue fieldValue = entry.getValue();
            if (!(fieldValue instanceof XmlSerializable)) {
                throw new RuntimeException("Error serializing. List item doesn't implement XmlSerializable");
            }
            ((XmlSerializable)fieldValue).xmlSerialize(fieldElement);
        }
    }
}

