/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.utils.XmlSerializable;
import org.apache.plc4x.java.spi.values.PlcValueAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcList
extends PlcValueAdapter {
    private List<PlcValue> listItems;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcList() {
        this.listItems = new ArrayList<PlcValue>();
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcList(@JsonProperty(value="listItems") List<PlcValue> listItems) {
        List safelist = listItems.stream().map(plcValue -> plcValue).collect(Collectors.toList());
        this.listItems = Collections.unmodifiableList(safelist);
    }

    public void add(PlcValue value) {
        this.listItems.add(value);
    }

    @Override
    public Object getObject() {
        return this.listItems;
    }

    @Override
    @JsonIgnore
    public boolean isList() {
        return true;
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return this.listItems.size();
    }

    @Override
    @JsonInclude
    public PlcValue getIndex(int i) {
        return this.listItems.get(i);
    }

    @JsonIgnore
    public List<PlcValue> getList() {
        return this.listItems;
    }

    @JsonIgnore
    public String toString() {
        return "[" + this.listItems.stream().map(Object::toString).collect(Collectors.joining(",")) + "]";
    }

    @Override
    public void xmlSerialize(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element plcValueElement = doc.createElement("PlcList");
        parent.appendChild(plcValueElement);
        for (PlcValue listItem : this.listItems) {
            if (!(listItem instanceof XmlSerializable)) {
                throw new RuntimeException("Error serializing. List item doesn't implement XmlSerializable");
            }
            ((XmlSerializable)listItem).xmlSerialize(plcValueElement);
        }
    }
}

