/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.spi.values.PlcIECValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcDWORD
extends PlcIECValue<Long> {
    static Long minValue = 0L;
    static Long maxValue = 0xFFFFFFFFL;

    public static PlcDWORD of(Object value) {
        if (value instanceof Boolean) {
            return new PlcDWORD((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcDWORD((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcDWORD((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcDWORD((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcDWORD((Long)value);
        }
        if (value instanceof Float) {
            return new PlcDWORD((Float)value);
        }
        if (value instanceof Double) {
            return new PlcDWORD((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcDWORD((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcDWORD((BigDecimal)value);
        }
        return new PlcDWORD((String)value);
    }

    public PlcDWORD(Boolean value) {
        this.value = value != false ? 1L : 0L;
        this.isNullable = false;
    }

    public PlcDWORD(Byte value) {
        if ((long)value.byteValue() < minValue || (long)value.byteValue() > maxValue) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcDWORD(Short value) {
        if ((long)value.shortValue() < minValue || (long)value.shortValue() > maxValue) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcDWORD(Integer value) {
        if ((long)value.intValue() < minValue || (long)value.intValue() > maxValue) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcDWORD(Long value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = (long)value;
        this.isNullable = false;
    }

    public PlcDWORD(Float value) {
        if (!(value.floatValue() >= (float)minValue.longValue()) || !(value.floatValue() <= (float)maxValue.longValue()) || value.floatValue() % 1.0f != 0.0f) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " or has decimal places for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcDWORD(Double value) {
        if (!(value >= (double)minValue.longValue()) || !(value <= (double)maxValue.longValue()) || value % 1.0 != 0.0) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " or has decimal places for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcDWORD(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(minValue)) < 0 || value.compareTo(BigInteger.valueOf(maxValue)) > 0) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.longValue();
        this.isNullable = true;
    }

    public PlcDWORD(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(minValue)) < 0 || value.compareTo(BigDecimal.valueOf(maxValue)) > 0 || value.scale() > 0) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value.longValue();
        this.isNullable = true;
    }

    public PlcDWORD(String value) {
        try {
            long val = Long.parseLong(value.trim());
            if (val < minValue || val > maxValue) {
                throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcDWORD(@JsonProperty(value="value") long value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException("Value of type " + value + " is out of range " + minValue + " - " + maxValue + " for a " + this.getClass().getSimpleName() + " Value");
        }
        this.value = value;
        this.isNullable = false;
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((Long)this.value).equals(0);
    }

    @JsonIgnore
    public boolean[] getBooleanArray() {
        boolean[] booleanValues = new boolean[32];
        BitSet bitSet = BitSet.valueOf(new long[]{(Long)this.value});
        for (int i = 0; i < 32; ++i) {
            booleanValues[i] = bitSet.get(i);
        }
        return booleanValues;
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return this.value != null && (Long)this.value <= 127L && (Long)this.value >= -128L;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return ((Long)this.value).byteValue();
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return this.value != null && (Long)this.value <= 32767L && (Long)this.value >= -32768L;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return ((Long)this.value).shortValue();
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return ((Long)this.value).intValue();
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return true;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return (Long)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return true;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((Long)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return ((Long)this.value).doubleValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return Long.toString((Long)this.value);
    }

    @JsonIgnore
    public byte[] getBytes() {
        byte[] bytes = new byte[]{(byte)((Long)this.value >> 24 & 0xFFL), (byte)((Long)this.value >> 16 & 0xFFL), (byte)((Long)this.value >> 8 & 0xFFL), (byte)((Long)this.value & 0xFFL)};
        return bytes;
    }
}

