/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;
import org.w3c.dom.Element;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcDATE
extends PlcSimpleValue<LocalDate> {
    public static PlcDATE of(Object value) {
        if (value instanceof LocalDate) {
            return new PlcDATE((LocalDate)value);
        }
        if (value instanceof Long) {
            return new PlcDATE(LocalDateTime.ofInstant(Instant.ofEpochSecond((Long)value), ZoneId.systemDefault()).toLocalDate());
        }
        throw new PlcRuntimeException("Invalid value type");
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcDATE(@JsonProperty(value="value") LocalDate value) {
        super(value, true);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcDATE(@JsonProperty(value="value") Integer value) {
        super(LocalDateTime.ofInstant(Instant.ofEpochSecond((value + 7305) * 86400), ZoneId.systemDefault()).toLocalDate(), true);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcDATE(@JsonProperty(value="value") Long value) {
        super(LocalDateTime.ofInstant(Instant.ofEpochSecond(value), ZoneId.systemDefault()).toLocalDate(), true);
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return ((LocalDate)this.value).toString();
    }

    @Override
    @JsonIgnore
    public boolean isDate() {
        return true;
    }

    @Override
    @JsonIgnore
    public LocalDate getDate() {
        return (LocalDate)this.value;
    }

    @JsonIgnore
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void xmlSerialize(Element parent) {
    }
}

