/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.plc4x.java.api.exceptions.PlcUnsupportedDataTypeException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcBigDecimal;
import org.apache.plc4x.java.spi.values.PlcBigInteger;
import org.apache.plc4x.java.spi.values.PlcCHAR;
import org.apache.plc4x.java.spi.values.PlcDATE;
import org.apache.plc4x.java.spi.values.PlcDATE_AND_TIME;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcDWORD;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcLWORD;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcSTRING;
import org.apache.plc4x.java.spi.values.PlcTIME;
import org.apache.plc4x.java.spi.values.PlcTIME_OF_DAY;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWCHAR;
import org.apache.plc4x.java.spi.values.PlcWORD;

public class IEC61131ValueHandler
implements PlcValueHandler {
    public PlcValue newPlcValue(Object value) {
        return IEC61131ValueHandler.of(new Object[]{value});
    }

    public PlcValue newPlcValue(Object[] values) {
        return IEC61131ValueHandler.of(values);
    }

    public PlcValue newPlcValue(PlcField field, Object value) {
        return IEC61131ValueHandler.of(field, new Object[]{value});
    }

    public PlcValue newPlcValue(PlcField field, Object[] values) {
        return IEC61131ValueHandler.of(field, values);
    }

    public static PlcValue of(Object value) {
        return IEC61131ValueHandler.of(new Object[]{value});
    }

    public static PlcValue of(Object[] values) {
        if (values.length == 1) {
            Object value = values[0];
            if (value instanceof Boolean) {
                return PlcBOOL.of(value);
            }
            if (value instanceof Byte) {
                return PlcSINT.of(value);
            }
            if (value instanceof Short) {
                return PlcINT.of(value);
            }
            if (value instanceof Integer) {
                return PlcDINT.of(value);
            }
            if (value instanceof Long) {
                return PlcLINT.of(value);
            }
            if (value instanceof BigInteger) {
                return new PlcBigInteger((BigInteger)value);
            }
            if (value instanceof Float) {
                return PlcREAL.of(value);
            }
            if (value instanceof Double) {
                return PlcLREAL.of(value);
            }
            if (value instanceof BigDecimal) {
                return new PlcBigDecimal((BigDecimal)value);
            }
            if (value instanceof Duration) {
                return new PlcTIME((Duration)value);
            }
            if (value instanceof LocalTime) {
                return new PlcTIME_OF_DAY((LocalTime)value);
            }
            if (value instanceof LocalDate) {
                return new PlcDATE((LocalDate)value);
            }
            if (value instanceof LocalDateTime) {
                return new PlcDATE_AND_TIME((LocalDateTime)value);
            }
            if (value instanceof String) {
                return new PlcSTRING((String)value);
            }
            if (value instanceof PlcValue) {
                return (PlcValue)value;
            }
            throw new PlcUnsupportedDataTypeException("Data Type " + value.getClass() + " Is not supported");
        }
        PlcList list = new PlcList();
        for (Object value : values) {
            list.add(IEC61131ValueHandler.of(new Object[]{value}));
        }
        return list;
    }

    public static PlcValue of(PlcField field, Object value) {
        return IEC61131ValueHandler.of(field, new Object[]{value});
    }

    public static PlcValue of(PlcField field, Object[] values) {
        if (values.length == 1) {
            Object value = values[0];
            switch (field.getPlcDataType().toUpperCase()) {
                case "IEC61131_BOOL": 
                case "IEC61131_BIT": {
                    return PlcBOOL.of(value);
                }
                case "IEC61131_BYTE": 
                case "IEC61131_BITARR8": {
                    return PlcBYTE.of(value);
                }
                case "IEC61131_SINT": 
                case "IEC61131_INT8": {
                    return PlcSINT.of(value);
                }
                case "IEC61131_USINT": 
                case "IEC61131_UINT8": 
                case "IEC61131_BIT8": {
                    return PlcUSINT.of(value);
                }
                case "IEC61131_INT": 
                case "IEC61131_INT16": {
                    return PlcINT.of(value);
                }
                case "IEC61131_UINT": 
                case "IEC61131_UINT16": {
                    return PlcUINT.of(value);
                }
                case "IEC61131_WORD": 
                case "IEC61131_BITARR16": {
                    return PlcWORD.of(value);
                }
                case "IEC61131_DINT": 
                case "IEC61131_INT32": {
                    return PlcDINT.of(value);
                }
                case "IEC61131_UDINT": 
                case "IEC61131_UINT32": {
                    return PlcUDINT.of(value);
                }
                case "IEC61131_DWORD": 
                case "IEC61131_BITARR32": {
                    return PlcDWORD.of(value);
                }
                case "IEC61131_LINT": 
                case "IEC61131_INT64": {
                    return PlcLINT.of(value);
                }
                case "IEC61131_ULINT": 
                case "IEC61131_UINT64": {
                    return PlcULINT.of(value);
                }
                case "IEC61131_LWORD": 
                case "IEC61131_BITARR64": {
                    return PlcLWORD.of(value);
                }
                case "IEC61131_REAL": 
                case "IEC61131_FLOAT": {
                    return PlcREAL.of(value);
                }
                case "IEC61131_LREAL": 
                case "IEC61131_DOUBLE": {
                    return PlcLREAL.of(value);
                }
                case "IEC61131_CHAR": {
                    return PlcCHAR.of(value);
                }
                case "IEC61131_WCHAR": {
                    return PlcWCHAR.of(value);
                }
                case "IEC61131_STRING": {
                    return PlcSTRING.of(value);
                }
                case "IEC61131_WSTRING": 
                case "IEC61131_STRING16": {
                    return PlcSTRING.of(value);
                }
                case "IEC61131_TIME": {
                    return PlcTIME.of(value);
                }
                case "IEC61131_DATE": {
                    return PlcDATE.of(value);
                }
                case "IEC61131_TIME_OF_DAY": {
                    return PlcTIME_OF_DAY.of(value);
                }
                case "IEC61131_DATE_AND_TIME": {
                    return PlcDATE_AND_TIME.of(value);
                }
            }
            return IEC61131ValueHandler.customDataType(field, new Object[]{value});
        }
        PlcList list = new PlcList();
        for (Object value : values) {
            list.add(IEC61131ValueHandler.of(field, new Object[]{value}));
        }
        return list;
    }

    public static PlcValue customDataType(PlcField field, Object[] values) {
        return IEC61131ValueHandler.of(values);
    }
}

