/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.Map;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.spi.utils.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcWriteResponse
implements PlcWriteResponse,
XmlSerializable {
    private final PlcWriteRequest request;
    private final Map<String, PlcResponseCode> values;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcWriteResponse(@JsonProperty(value="request") PlcWriteRequest request, @JsonProperty(value="values") Map<String, PlcResponseCode> values) {
        this.request = request;
        this.values = values;
    }

    public PlcWriteRequest getRequest() {
        return this.request;
    }

    @JsonIgnore
    public Collection<String> getFieldNames() {
        return this.request.getFieldNames();
    }

    @JsonIgnore
    public PlcField getField(String name) {
        return this.request.getField(name);
    }

    @JsonIgnore
    public PlcResponseCode getResponseCode(String name) {
        return this.values.get(name);
    }

    @Override
    public void xmlSerialize(Element parent) {
        Document doc = parent.getOwnerDocument();
        Element messageElement = doc.createElement("PlcWriteResponse");
        if (this.request instanceof XmlSerializable) {
            ((XmlSerializable)this.request).xmlSerialize(messageElement);
        }
        Element fieldsElement = doc.createElement("fields");
        messageElement.appendChild(fieldsElement);
        for (Map.Entry<String, PlcResponseCode> fieldEntry : this.values.entrySet()) {
            String fieldName = fieldEntry.getKey();
            PlcResponseCode fieldResponseCode = fieldEntry.getValue();
            Element fieldNameElement = doc.createElement(fieldName);
            fieldNameElement.setAttribute("result", fieldResponseCode.name());
            fieldsElement.appendChild(fieldNameElement);
        }
        parent.appendChild(messageElement);
    }
}

