/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.messages.PlcRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.utils.XmlSerializable;
import org.w3c.dom.Element;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcUnsubscriptionRequest
implements PlcUnsubscriptionRequest,
PlcRequest,
XmlSerializable {
    private final PlcSubscriber subscriber;
    private final List<PlcSubscriptionHandle> plcSubscriptionHandles;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcUnsubscriptionRequest(@JsonProperty(value="subscriber") PlcSubscriber subscriber, @JsonProperty(value="internalPlcSubscriptionHandles") List<PlcSubscriptionHandle> plcSubscriptionHandles) {
        this.subscriber = subscriber;
        this.plcSubscriptionHandles = plcSubscriptionHandles;
    }

    @JsonIgnore
    public CompletableFuture<PlcUnsubscriptionResponse> execute() {
        return this.subscriber.unsubscribe(this);
    }

    public List<PlcSubscriptionHandle> getSubscriptionHandles() {
        return this.plcSubscriptionHandles;
    }

    public PlcSubscriber getSubscriber() {
        return this.subscriber;
    }

    public Collection<PlcSubscriptionHandle> getPlcSubscriptionHandles() {
        return this.plcSubscriptionHandles;
    }

    @Override
    public void xmlSerialize(Element parent) {
    }

    public static class Builder
    implements PlcUnsubscriptionRequest.Builder {
        private final PlcSubscriber subscriber;
        private List<PlcSubscriptionHandle> plcSubscriptionHandles;

        public Builder(PlcSubscriber subscriber) {
            this.subscriber = subscriber;
            this.plcSubscriptionHandles = new ArrayList<PlcSubscriptionHandle>();
        }

        public PlcUnsubscriptionRequest.Builder addHandles(PlcSubscriptionHandle plcSubscriptionHandle) {
            this.plcSubscriptionHandles.add(plcSubscriptionHandle);
            return this;
        }

        public PlcUnsubscriptionRequest.Builder addHandles(PlcSubscriptionHandle plcSubscriptionHandle1, PlcSubscriptionHandle ... plcSubscriptionHandles) {
            this.plcSubscriptionHandles.add(plcSubscriptionHandle1);
            this.plcSubscriptionHandles.addAll(Arrays.stream(plcSubscriptionHandles).map(PlcSubscriptionHandle.class::cast).collect(Collectors.toList()));
            return this;
        }

        public PlcUnsubscriptionRequest.Builder addHandles(Collection<PlcSubscriptionHandle> plcSubscriptionHandles) {
            this.plcSubscriptionHandles.addAll(plcSubscriptionHandles.stream().map(PlcSubscriptionHandle.class::cast).collect(Collectors.toList()));
            return this;
        }

        public PlcUnsubscriptionRequest build() {
            return new DefaultPlcUnsubscriptionRequest(this.subscriber, this.plcSubscriptionHandles);
        }
    }
}

