/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import com.github.jinahya.bit.io.BufferByteOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.io.MyDefaultBitOutput;

public class WriteBuffer {
    private final ByteBuffer bb;
    private final BufferByteOutput bbo;
    private final MyDefaultBitOutput bo;
    private final boolean littleEndian;

    public WriteBuffer(int size) {
        this(size, false);
    }

    public WriteBuffer(int size, boolean littleEndian) {
        this.bb = ByteBuffer.allocate(size);
        this.bbo = new BufferByteOutput(this.bb);
        this.bo = new MyDefaultBitOutput(this.bbo);
        this.littleEndian = littleEndian;
    }

    public byte[] getData() {
        return this.bb.array();
    }

    public int getPos() {
        return (int)this.bo.getPos();
    }

    public byte[] getBytes(int startPos, int endPos) {
        int numBytes = endPos - startPos;
        byte[] data = new byte[numBytes];
        System.arraycopy(this.bb.array(), startPos, data, 0, numBytes);
        return data;
    }

    public void writeBit(boolean value) throws ParseException {
        try {
            this.bo.writeBoolean(value);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public void writeUnsignedByte(int bitLength, byte value) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned byte must contain at least 1 bit");
        }
        if (bitLength > 8) {
            throw new ParseException("unsigned byte can only contain max 8 bits");
        }
        try {
            this.bo.writeByte(true, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public void writeUnsignedShort(int bitLength, short value) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned short must contain at least 1 bit");
        }
        if (bitLength > 16) {
            throw new ParseException("unsigned short can only contain max 16 bits");
        }
        try {
            this.bo.writeShort(true, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public void writeUnsignedInt(int bitLength, int value) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned int must contain at least 1 bit");
        }
        if (bitLength > 32) {
            throw new ParseException("unsigned int can only contain max 32 bits");
        }
        try {
            if (this.littleEndian) {
                value = Integer.reverseBytes(value) >> 16;
            }
            this.bo.writeInt(true, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public void writeUnsignedLong(int bitLength, long value) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned long must contain at least 1 bit");
        }
        if (bitLength > 63) {
            throw new ParseException("unsigned long can only contain max 63 bits");
        }
        try {
            if (this.littleEndian) {
                value = Long.reverseBytes(value) >> 32;
            }
            this.bo.writeLong(true, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public void writeUnsignedBigInteger(int bitLength, BigInteger value) throws ParseException {
        block10: {
            try {
                if (bitLength == 64) {
                    if (this.littleEndian) {
                        if (value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
                            this.writeLong(32, value.longValue());
                            this.writeLong(32, value.shiftRight(32).longValue());
                        } else {
                            this.writeLong(bitLength, value.longValue());
                        }
                    } else if (value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
                        this.writeLong(32, value.shiftRight(32).longValue());
                        this.writeLong(32, value.longValue());
                    } else {
                        this.writeLong(bitLength, value.longValue());
                    }
                    break block10;
                }
                if (bitLength < 64) {
                    this.writeUnsignedLong(bitLength, value.longValue());
                    break block10;
                }
                throw new ParseException("Unsigned Big Integer can only contain max 64 bits");
            }
            catch (ArithmeticException e) {
                throw new ParseException("Error reading", e);
            }
        }
    }

    public void writeByte(int bitLength, byte value) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("byte must contain at least 1 bit");
        }
        if (bitLength > 8) {
            throw new ParseException("byte can only contain max 8 bits");
        }
        try {
            this.bo.writeByte(false, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public void writeShort(int bitLength, short value) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("short must contain at least 1 bit");
        }
        if (bitLength > 16) {
            throw new ParseException("short can only contain max 16 bits");
        }
        try {
            if (this.littleEndian) {
                value = Short.reverseBytes(value);
            }
            this.bo.writeShort(false, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public void writeInt(int bitLength, int value) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("int must contain at least 1 bit");
        }
        if (bitLength > 32) {
            throw new ParseException("int can only contain max 32 bits");
        }
        try {
            if (this.littleEndian) {
                value = Integer.reverseBytes(value);
            }
            this.bo.writeInt(false, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public void writeLong(int bitLength, long value) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("long must contain at least 1 bit");
        }
        if (bitLength > 64) {
            throw new ParseException("long can only contain max 64 bits");
        }
        try {
            if (this.littleEndian) {
                value = Long.reverseBytes(value);
            }
            this.bo.writeLong(false, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public void writeBigInteger(int bitLength, BigInteger value) throws ParseException {
        try {
            if (bitLength > 64) {
                throw new ParseException("Big Integer can only contain max 64 bits");
            }
            this.writeLong(bitLength, value.longValue());
        }
        catch (ArithmeticException e) {
            throw new ParseException("Error reading", e);
        }
    }

    public void writeFloat(float value, int bitsExponent, int bitsMantissa) throws ParseException {
        if (bitsExponent != 8 || bitsMantissa != 23) {
            throw new UnsupportedOperationException("Exponent and/or Mantissa non standard size");
        }
        this.writeInt(1 + bitsExponent + bitsMantissa, Float.floatToRawIntBits(value));
    }

    public void writeDouble(double value, int bitsExponent, int bitsMantissa) throws ParseException {
        if (bitsExponent != 11 || bitsMantissa != 52) {
            throw new UnsupportedOperationException("Exponent and/or Mantissa non standard size");
        }
        this.writeLong(1 + bitsExponent + bitsMantissa, Double.doubleToRawLongBits(value));
    }

    public void writeBigDecimal(int bitLength, BigDecimal value) throws ParseException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void writeString(int bitLength, String encoding, String value) throws ParseException {
        byte[] bytes = value.getBytes(Charset.forName(encoding));
        try {
            for (byte aByte : bytes) {
                this.bo.writeByte(false, 8, aByte);
            }
        }
        catch (IOException e) {
            throw new ParseException("Error writing string", e);
        }
    }
}

