/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import java.util.Collection;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;

public class StaticHelper {
    public static int ARRAY_SIZE_IN_BYTES(Object obj) {
        if (obj.getClass().isArray() && !obj.getClass().getComponentType().isPrimitive()) {
            Object[] arr = (Object[])obj;
            int numBytes = 0;
            for (Object element : arr) {
                if (element instanceof Message) {
                    numBytes += ((Message)element).getLengthInBytes();
                    continue;
                }
                throw new RuntimeException("Array elements for array size in bytes must implement Message interface");
            }
            return numBytes;
        }
        throw new RuntimeException("Unable to calculate array size in bytes for type " + obj.getClass().getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int COUNT(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj.getClass().getComponentType() != null && obj.getClass().getComponentType().isPrimitive()) {
                if (obj.getClass().getComponentType() == Boolean.TYPE) {
                    boolean[] arr = (boolean[])obj;
                    return arr.length;
                }
                if (obj.getClass().getComponentType() == Byte.TYPE) {
                    byte[] arr = (byte[])obj;
                    return arr.length;
                }
                if (obj.getClass().getComponentType() == Short.TYPE) {
                    short[] arr = (short[])obj;
                    return arr.length;
                }
                if (obj.getClass().getComponentType() == Integer.TYPE) {
                    int[] arr = (int[])obj;
                    return arr.length;
                }
                if (obj.getClass().getComponentType() == Long.TYPE) {
                    long[] arr = (long[])obj;
                    return arr.length;
                }
                if (obj.getClass().getComponentType() == Float.TYPE) {
                    float[] arr = (float[])obj;
                    return arr.length;
                }
                if (obj.getClass().getComponentType() != Double.TYPE) throw new RuntimeException("Unable to count object of type " + obj.getClass().getName());
                double[] arr = (double[])obj;
                return arr.length;
            }
            Object[] arr = (Object[])obj;
            return arr.length;
        }
        if (!(obj instanceof Collection)) throw new RuntimeException("Unable to count object of type " + obj.getClass().getName());
        Collection col = (Collection)obj;
        return col.size();
    }

    public static <T> T CAST(Object obj, Class<T> clazz) {
        try {
            return clazz.cast(obj);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Unable to cast object of type " + obj.getClass().getName() + " to " + clazz.getName());
        }
    }

    public static int CEIL(double value) {
        return (int)Math.ceil(value);
    }

    public static double toFloat(ReadBuffer io, boolean signed, int bitsExponent, int bitsMantissa) {
        try {
            if (signed && bitsExponent == 8 && bitsMantissa == 23) {
                return io.readFloat(32);
            }
            if (signed && bitsExponent == 11 & bitsMantissa == 52) {
                return io.readDouble(64);
            }
            boolean negative = signed && io.readBit();
            long exponent = io.readUnsignedLong(bitsExponent);
            exponent -= (long)Math.pow(2.0, bitsExponent) / 2L - 1L;
            double mantissa = 1.0;
            for (int i = 1; i <= bitsMantissa; ++i) {
                if (!io.readBit()) continue;
                mantissa += Math.pow(2.0, (double)i * -1.0);
            }
            return (double)(negative ? -1 : 1) * mantissa * Math.pow(2.0, exponent);
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public static boolean fromFloatSign(double value) {
        return value < 0.0;
    }

    public static long fromFloatExponent(double value, int bitsExponent) {
        return 0L;
    }

    public static long fromFloatMantissa(double value, int bitsMantissa) {
        return 0L;
    }

    public static void main(String[] args) throws Exception {
        byte[] bytes = Hex.decodeHex((String)"0C65");
        ReadBuffer io = new ReadBuffer(bytes);
        double v = StaticHelper.toFloat(io, true, 4, 11);
        System.out.println(v);
    }
}

