/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.Plc4xNettyWrapper;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.connection.GeneratedProtocolMessageCodec;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;

public class SingleProtocolStackConfigurer<BASE_PACKET_CLASS extends Message>
implements ProtocolStackConfigurer<BASE_PACKET_CLASS> {
    private final Class<BASE_PACKET_CLASS> basePacketClass;
    private boolean bigEndian = true;
    private final Class<? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocolClass;
    private final Class<? extends DriverContext> driverContextClass;
    private final MessageIO<BASE_PACKET_CLASS, BASE_PACKET_CLASS> protocolIO;
    private final Class<? extends ToIntFunction<ByteBuf>> packetSizeEstimatorClass;
    private final Class<? extends Consumer<ByteBuf>> corruptPacketRemoverClass;
    private final Object[] parserArgs;

    public static <BPC extends Message> SingleProtocolStackBuilder<BPC> builder(Class<BPC> basePacketClass, Class<? extends MessageIO<BPC, BPC>> messageIoClass) {
        return new SingleProtocolStackBuilder<BPC>(basePacketClass, messageIoClass);
    }

    SingleProtocolStackConfigurer(Class<BASE_PACKET_CLASS> basePacketClass, boolean bigEndian, Object[] parserArgs, Class<? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol, Class<? extends DriverContext> driverContextClass, MessageIO<BASE_PACKET_CLASS, BASE_PACKET_CLASS> protocolIO, Class<? extends ToIntFunction<ByteBuf>> packetSizeEstimatorClass, Class<? extends Consumer<ByteBuf>> corruptPacketRemoverClass) {
        this.basePacketClass = basePacketClass;
        this.bigEndian = bigEndian;
        this.parserArgs = parserArgs;
        this.protocolClass = protocol;
        this.driverContextClass = driverContextClass;
        this.protocolIO = protocolIO;
        this.packetSizeEstimatorClass = packetSizeEstimatorClass;
        this.corruptPacketRemoverClass = corruptPacketRemoverClass;
    }

    private ChannelHandler getMessageCodec(Configuration configuration) {
        return new GeneratedProtocolMessageCodec<BASE_PACKET_CLASS>(this.basePacketClass, this.protocolIO, this.bigEndian, this.parserArgs, this.packetSizeEstimatorClass != null ? ConfigurationFactory.configure(configuration, this.createInstance(this.packetSizeEstimatorClass, new Object[0])) : null, this.corruptPacketRemoverClass != null ? ConfigurationFactory.configure(configuration, this.createInstance(this.corruptPacketRemoverClass, new Object[0])) : null);
    }

    @Override
    public Plc4xProtocolBase<BASE_PACKET_CLASS> configurePipeline(Configuration configuration, ChannelPipeline pipeline, boolean passive) {
        pipeline.addLast(new ChannelHandler[]{this.getMessageCodec(configuration)});
        Plc4xProtocolBase<BASE_PACKET_CLASS> protocol = ConfigurationFactory.configure(configuration, this.createInstance(this.protocolClass, new Object[0]));
        if (this.driverContextClass != null) {
            protocol.setDriverContext(ConfigurationFactory.configure(configuration, this.createInstance(this.driverContextClass, new Object[0])));
        }
        Plc4xNettyWrapper<BASE_PACKET_CLASS> context = new Plc4xNettyWrapper<BASE_PACKET_CLASS>(pipeline, passive, protocol, this.basePacketClass);
        pipeline.addLast(new ChannelHandler[]{context});
        return protocol;
    }

    private <T> T createInstance(Class<T> clazz, Object ... args) {
        try {
            Class[] parameterTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                parameterTypes[i] = args[i].getClass();
            }
            return clazz.getDeclaredConstructor(parameterTypes).newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PlcRuntimeException("Error creating instance of class " + clazz.getName());
        }
    }

    public static final class SingleProtocolStackBuilder<BASE_PACKET_CLASS extends Message> {
        private final Class<BASE_PACKET_CLASS> basePacketClass;
        private final Class<? extends MessageIO<BASE_PACKET_CLASS, BASE_PACKET_CLASS>> messageIoClass;
        private Class<? extends DriverContext> driverContextClass;
        private boolean bigEndian = true;
        private Object[] parserArgs;
        private Class<? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol;
        private Class<? extends ToIntFunction<ByteBuf>> packetSizeEstimator;
        private Class<? extends Consumer<ByteBuf>> corruptPacketRemover;

        public SingleProtocolStackBuilder(Class<BASE_PACKET_CLASS> basePacketClass, Class<? extends MessageIO<BASE_PACKET_CLASS, BASE_PACKET_CLASS>> messageIoClass) {
            this.basePacketClass = basePacketClass;
            this.messageIoClass = messageIoClass;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> withDriverContext(Class<? extends DriverContext> driverContextClass) {
            this.driverContextClass = driverContextClass;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> littleEndian() {
            this.bigEndian = false;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> withParserArgs(Object ... parserArgs) {
            this.parserArgs = parserArgs;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> withProtocol(Class<? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol) {
            this.protocol = protocol;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> withPacketSizeEstimator(Class<? extends ToIntFunction<ByteBuf>> packetSizeEstimator) {
            this.packetSizeEstimator = packetSizeEstimator;
            return this;
        }

        public SingleProtocolStackBuilder<BASE_PACKET_CLASS> withCorruptPacketRemover(Class<? extends Consumer<ByteBuf>> corruptPacketRemover) {
            this.corruptPacketRemover = corruptPacketRemover;
            return this;
        }

        public SingleProtocolStackConfigurer<BASE_PACKET_CLASS> build() {
            assert (this.protocol != null);
            try {
                MessageIO<BASE_PACKET_CLASS, BASE_PACKET_CLASS> messageIo = this.messageIoClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return new SingleProtocolStackConfigurer<BASE_PACKET_CLASS>(this.basePacketClass, this.bigEndian, this.parserArgs, this.protocol, this.driverContextClass, messageIo, this.packetSizeEstimator, this.corruptPacketRemover);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new PlcRuntimeException("Error initializing MessageIO instance", (Throwable)e);
            }
        }
    }
}

