/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.packaging;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.war.Overlay;
import org.apache.maven.plugin.war.packaging.AbstractWarPackagingTask;
import org.apache.maven.plugin.war.packaging.WarPackagingContext;
import org.apache.maven.plugin.war.util.ClassesPackager;
import org.apache.maven.plugin.war.util.PathSet;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;

public class ClassesPackagingTask
extends AbstractWarPackagingTask {
    public void performPackaging(WarPackagingContext context) throws MojoExecutionException {
        File webappClassesDirectory = new File(context.getWebappDirectory(), "WEB-INF/classes/");
        if (!webappClassesDirectory.exists()) {
            webappClassesDirectory.mkdirs();
        }
        if (context.getClassesDirectory().exists() && !context.getClassesDirectory().equals(webappClassesDirectory)) {
            if (context.archiveClasses()) {
                this.generateJarArchive(context);
            } else {
                PathSet sources = this.getFilesToIncludes(context.getClassesDirectory(), null, null);
                try {
                    this.copyFiles(Overlay.currentProjectInstance().getId(), context, context.getClassesDirectory(), sources, "WEB-INF/classes/", false);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Could not copy webapp classes[" + context.getClassesDirectory().getAbsolutePath() + "]", (Exception)e);
                }
            }
        }
    }

    protected void generateJarArchive(WarPackagingContext context) throws MojoExecutionException {
        MavenProject project = context.getProject();
        ArtifactFactory factory = context.getArtifactFactory();
        Artifact artifact = factory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), "jar");
        String archiveName = null;
        try {
            archiveName = this.getArtifactFinalName(context, artifact);
        }
        catch (InterpolationException e) {
            throw new MojoExecutionException("Could not get the final name of the artifact[" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + "]", (Exception)((Object)e));
        }
        String targetFilename = "WEB-INF/lib/" + archiveName;
        if (context.getWebappStructure().registerFile(Overlay.currentProjectInstance().getId(), targetFilename)) {
            File libDirectory = new File(context.getWebappDirectory(), "WEB-INF/lib/");
            File jarFile = new File(libDirectory, archiveName);
            ClassesPackager packager = new ClassesPackager();
            packager.packageClasses(context.getClassesDirectory(), jarFile, context.getJarArchiver(), project, context.getArchive());
        } else {
            context.getLog().warn((CharSequence)("Could not generate archive classes file[" + targetFilename + "] has already been copied."));
        }
    }
}

