/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.deploy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.deploy.AbstractDeployMojo;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DeployFileMojo
extends AbstractDeployMojo {
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging;
    private File file;
    private String repositoryId;
    private String url;
    private ArtifactFactory artifactFactory;
    private ArtifactRepositoryLayout layout;
    private ArtifactRepositoryFactory repositoryFactory;
    private File pomFile;
    private boolean generatePom = true;
    private String classifier;
    private boolean uniqueVersion;

    public void execute() throws MojoExecutionException {
        this.initProperties();
        Artifact pomArtifact = null;
        try {
            Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
            ArtifactRepository deploymentRepository = this.repositoryFactory.createDeploymentArtifactRepository(this.repositoryId, this.url, this.layout, this.uniqueVersion);
            if (this.generatePom) {
                if (!this.isPomFileExisting()) {
                    this.generatePomFile();
                }
                ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, this.pomFile);
                artifact.addMetadata((ArtifactMetadata)metadata);
            } else if (this.isPomFileExisting()) {
                pomArtifact = this.artifactFactory.createArtifact(this.groupId, this.artifactId, this.version, null, "pom");
            }
            if (!this.file.exists()) {
                throw new MojoExecutionException(this.file.getPath() + " not found.");
            }
            String protocol = deploymentRepository.getProtocol();
            if (protocol.equals("") || protocol == null) {
                throw new MojoExecutionException("No transfer protocol found.");
            }
            this.getDeployer().deploy(this.file, artifact, deploymentRepository, this.getLocalRepository());
            if (this.isPomFileExisting() && !this.generatePom) {
                this.getDeployer().deploy(this.pomFile, pomArtifact, deploymentRepository, this.getLocalRepository());
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private boolean isPomFileExisting() {
        boolean existing = false;
        if (this.pomFile != null && this.pomFile.exists()) {
            existing = true;
        }
        return existing;
    }

    void initProperties() throws MojoExecutionException {
        if (this.pomFile != null) {
            this.generatePom = false;
            Model model = this.readModel(this.pomFile);
            this.processModel(model);
        }
        if (this.groupId == null || this.artifactId == null || this.version == null || this.packaging == null) {
            throw new MojoExecutionException("Missing group, artifact, version, or packaging information");
        }
    }

    void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            if (parent != null && parent.getGroupId() != null) {
                this.groupId = parent.getGroupId();
            }
            if (model.getGroupId() != null) {
                this.groupId = model.getGroupId();
            }
        }
        if (this.artifactId == null && model.getArtifactId() != null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null && model.getVersion() != null) {
            this.version = model.getVersion();
        }
        if (this.packaging == null && model.getPackaging() != null) {
            this.packaging = model.getPackaging();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Model readModel(File pomFile) throws MojoExecutionException {
        Model model;
        if (!pomFile.exists()) {
            throw new MojoExecutionException("Specified pomFile does not exist");
        }
        FileReader reader = null;
        try {
            reader = new FileReader(pomFile);
            MavenXpp3Reader modelReader = new MavenXpp3Reader();
            model = modelReader.read((Reader)reader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("Error reading specified POM file: " + e.getMessage(), (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Error reading specified POM file: " + e2.getMessage(), (Exception)e2);
                }
                catch (XmlPullParserException e3) {
                    throw new MojoExecutionException("Error reading specified POM file: " + e3.getMessage(), (Exception)((Object)e3));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return model;
    }

    private void generatePomFile() throws MojoExecutionException {
        FileWriter fw = null;
        try {
            File tempFile = File.createTempFile("mvninstall", ".pom");
            tempFile.deleteOnExit();
            Model model = new Model();
            model.setModelVersion("4.0.0");
            model.setGroupId(this.groupId);
            model.setArtifactId(this.artifactId);
            model.setVersion(this.version);
            model.setPackaging(this.packaging);
            model.setDescription("POM was created from deploy:deploy-file");
            fw = new FileWriter(tempFile);
            new MavenXpp3Writer().write((Writer)fw, model);
            this.pomFile = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
    }

    void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    void setVersion(String version) {
        this.version = version;
    }

    void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    void setPomFile(File pomFile) {
        this.pomFile = pomFile;
    }

    String getGroupId() {
        return this.groupId;
    }

    String getArtifactId() {
        return this.artifactId;
    }

    String getVersion() {
        return this.version;
    }

    String getPackaging() {
        return this.packaging;
    }

    File getFile() {
        return this.file;
    }

    String getClassifier() {
        return this.classifier;
    }

    void setClassifier(String classifier) {
        this.classifier = classifier;
    }
}

