/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.filter;

import java.nio.file.Paths;
import org.apache.maven.plugins.assembly.filter.AbstractLineAggregatingHandler;
import org.apache.maven.plugins.assembly.filter.ContainerDescriptorHandler;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;

@Component(role=ContainerDescriptorHandler.class, hint="metaInf-services", instantiationStrategy="per-lookup")
public class MetaInfServicesHandler
extends AbstractLineAggregatingHandler {
    private static final String SERVICES_PATH_PREFIX = "META-INF/services/";

    @Override
    protected String getOutputPathPrefix(FileInfo fileInfo) {
        return Paths.get(fileInfo.getName(), new String[0]).getParent().toString() + "/";
    }

    @Override
    protected boolean fileMatches(FileInfo fileInfo) {
        String path = fileInfo.getName();
        String leftover = null;
        if (path.startsWith(SERVICES_PATH_PREFIX)) {
            leftover = path.substring(SERVICES_PATH_PREFIX.length());
        } else if (path.startsWith("/META-INF/services/")) {
            leftover = path.substring(SERVICES_PATH_PREFIX.length() - 1);
        }
        return leftover != null && leftover.length() > 0;
    }
}

