/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.utils;

import java.io.IOException;
import java.io.InputStream;

class LinuxLineFeedInputStream
extends InputStream {
    private boolean slashNSeen = false;
    private boolean eofSeen = false;
    private final InputStream target;
    private final boolean ensureLineFeedAtEndOfFile;

    public LinuxLineFeedInputStream(InputStream in, boolean ensureLineFeedAtEndOfFile) {
        this.target = in;
        this.ensureLineFeedAtEndOfFile = ensureLineFeedAtEndOfFile;
    }

    private int readWithUpdate() throws IOException {
        int target = this.target.read();
        boolean bl = this.eofSeen = target == -1;
        if (this.eofSeen) {
            return target;
        }
        this.slashNSeen = target == 10;
        return target;
    }

    public int read() throws IOException {
        if (this.eofSeen) {
            return this.eofGame();
        }
        int target = this.readWithUpdate();
        if (this.eofSeen) {
            return this.eofGame();
        }
        if (target == 13) {
            target = this.readWithUpdate();
        }
        return target;
    }

    private int eofGame() {
        if (!this.ensureLineFeedAtEndOfFile) {
            return -1;
        }
        if (!this.slashNSeen) {
            this.slashNSeen = true;
            return 10;
        }
        return -1;
    }

    public void close() throws IOException {
        super.close();
        this.target.close();
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("Mark not implemented yet");
    }
}

