/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NearestNeighbor;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SloppyMath;
import org.apache.lucene.util.bkd.BKDReader;

public class LatLonPointPrototypeQueries {
    private LatLonPointPrototypeQueries() {
    }

    public static TopFieldDocs nearest(IndexSearcher searcher, String field, double latitude, double longitude, int n) throws IOException {
        GeoUtils.checkLatitude((double)latitude);
        GeoUtils.checkLongitude((double)longitude);
        if (n < 1) {
            throw new IllegalArgumentException("n must be at least 1; got " + n);
        }
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (searcher == null) {
            throw new IllegalArgumentException("searcher must not be null");
        }
        ArrayList<BKDReader> readers = new ArrayList<BKDReader>();
        ArrayList<Integer> docBases = new ArrayList<Integer>();
        ArrayList<Bits> liveDocs = new ArrayList<Bits>();
        int totalHits = 0;
        for (LeafReaderContext leaf : searcher.getIndexReader().leaves()) {
            PointValues points = leaf.reader().getPointValues(field);
            if (points == null) continue;
            if (!(points instanceof BKDReader)) {
                throw new IllegalArgumentException("can only run on Lucene60PointsReader points implementation, but got " + points);
            }
            totalHits += points.getDocCount();
            BKDReader reader = (BKDReader)points;
            if (reader == null) continue;
            readers.add(reader);
            docBases.add(leaf.docBase);
            liveDocs.add(leaf.reader().getLiveDocs());
        }
        NearestNeighbor.NearestHit[] hits = NearestNeighbor.nearest(latitude, longitude, readers, liveDocs, docBases, n);
        ScoreDoc[] scoreDocs = new ScoreDoc[hits.length];
        for (int i = 0; i < hits.length; ++i) {
            NearestNeighbor.NearestHit hit = hits[i];
            double hitDistance = SloppyMath.haversinMeters((double)hit.distanceSortKey);
            scoreDocs[i] = new FieldDoc(hit.docID, 0.0f, new Object[]{hitDistance});
        }
        return new TopFieldDocs(new TotalHits((long)totalHits, TotalHits.Relation.EQUAL_TO), scoreDocs, null);
    }
}

