/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.facet.range.LongRange;

final class LongRangeCounter {
    final LongRangeNode root;
    final long[] boundaries;
    final int[] leafCounts;
    private int leafUpto;
    private int missingCount;

    public LongRangeCounter(LongRange[] ranges) {
        int i;
        long prev;
        HashMap<Long, Integer> endsMap = new HashMap<Long, Integer>();
        endsMap.put(Long.MIN_VALUE, 1);
        endsMap.put(Long.MAX_VALUE, 2);
        for (LongRange range : ranges) {
            Integer cur = (Integer)endsMap.get(range.min);
            if (cur == null) {
                endsMap.put(range.min, 1);
            } else {
                endsMap.put(range.min, cur | 1);
            }
            cur = (Integer)endsMap.get(range.max);
            if (cur == null) {
                endsMap.put(range.max, 2);
                continue;
            }
            endsMap.put(range.max, cur | 2);
        }
        ArrayList endsList = new ArrayList(endsMap.keySet());
        Collections.sort(endsList);
        ArrayList<InclusiveRange> elementaryIntervals = new ArrayList<InclusiveRange>();
        int upto0 = 1;
        long v = (Long)endsList.get(0);
        if ((Integer)endsMap.get(v) == 3) {
            elementaryIntervals.add(new InclusiveRange(v, v));
            prev = v + 1L;
        } else {
            prev = v;
        }
        while (upto0 < endsList.size()) {
            v = (Long)endsList.get(upto0);
            int flags = (Integer)endsMap.get(v);
            if (flags == 3) {
                if (v > prev) {
                    elementaryIntervals.add(new InclusiveRange(prev, v - 1L));
                }
                elementaryIntervals.add(new InclusiveRange(v, v));
                prev = v + 1L;
            } else if (flags == 1) {
                if (v > prev) {
                    elementaryIntervals.add(new InclusiveRange(prev, v - 1L));
                }
                prev = v;
            } else {
                assert (flags == 2);
                elementaryIntervals.add(new InclusiveRange(prev, v));
                prev = v + 1L;
            }
            ++upto0;
        }
        this.root = LongRangeCounter.split(0, elementaryIntervals.size(), elementaryIntervals);
        for (i = 0; i < ranges.length; ++i) {
            this.root.addOutputs(i, ranges[i]);
        }
        this.boundaries = new long[elementaryIntervals.size()];
        for (i = 0; i < this.boundaries.length; ++i) {
            this.boundaries[i] = ((InclusiveRange)elementaryIntervals.get((int)i)).end;
        }
        this.leafCounts = new int[this.boundaries.length];
    }

    public void add(long v) {
        int mid;
        int lo = 0;
        int hi = this.boundaries.length - 1;
        while (true) {
            if (v <= this.boundaries[mid = lo + hi >>> 1]) {
                if (mid == 0) {
                    this.leafCounts[0] = this.leafCounts[0] + 1;
                    return;
                }
                hi = mid - 1;
                continue;
            }
            if (v <= this.boundaries[mid + 1]) break;
            lo = mid + 1;
        }
        int n = mid + 1;
        this.leafCounts[n] = this.leafCounts[n] + 1;
    }

    public int fillCounts(int[] counts) {
        this.missingCount = 0;
        this.leafUpto = 0;
        this.rollup(this.root, counts, false);
        return this.missingCount;
    }

    private int rollup(LongRangeNode node, int[] counts, boolean sawOutputs) {
        int count;
        sawOutputs |= node.outputs != null;
        if (node.left != null) {
            count = this.rollup(node.left, counts, sawOutputs);
            count += this.rollup(node.right, counts, sawOutputs);
        } else {
            count = this.leafCounts[this.leafUpto];
            ++this.leafUpto;
            if (!sawOutputs) {
                this.missingCount += count;
            }
        }
        if (node.outputs != null) {
            Iterator<Integer> iterator = node.outputs.iterator();
            while (iterator.hasNext()) {
                int rangeIndex;
                int n = rangeIndex = iterator.next().intValue();
                counts[n] = counts[n] + count;
            }
        }
        return count;
    }

    private static LongRangeNode split(int start, int end, List<InclusiveRange> elementaryIntervals) {
        if (start == end - 1) {
            InclusiveRange range = elementaryIntervals.get(start);
            return new LongRangeNode(range.start, range.end, null, null, start);
        }
        int mid = start + end >>> 1;
        LongRangeNode left = LongRangeCounter.split(start, mid, elementaryIntervals);
        LongRangeNode right = LongRangeCounter.split(mid, end, elementaryIntervals);
        return new LongRangeNode(left.start, right.end, left, right, -1);
    }

    public static final class LongRangeNode {
        final LongRangeNode left;
        final LongRangeNode right;
        final long start;
        final long end;
        final int leafIndex;
        List<Integer> outputs;

        public LongRangeNode(long start, long end, LongRangeNode left, LongRangeNode right, int leafIndex) {
            this.start = start;
            this.end = end;
            this.left = left;
            this.right = right;
            this.leafIndex = leafIndex;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb, 0);
            return sb.toString();
        }

        static void indent(StringBuilder sb, int depth) {
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
        }

        void addOutputs(int index, LongRange range) {
            if (this.start >= range.min && this.end <= range.max) {
                if (this.outputs == null) {
                    this.outputs = new ArrayList<Integer>();
                }
                this.outputs.add(index);
            } else if (this.left != null) {
                assert (this.right != null);
                this.left.addOutputs(index, range);
                this.right.addOutputs(index, range);
            }
        }

        void toString(StringBuilder sb, int depth) {
            LongRangeNode.indent(sb, depth);
            if (this.left == null) {
                assert (this.right == null);
                sb.append("leaf: " + this.start + " to " + this.end);
            } else {
                sb.append("node: " + this.start + " to " + this.end);
            }
            if (this.outputs != null) {
                sb.append(" outputs=");
                sb.append(this.outputs);
            }
            sb.append('\n');
            if (this.left != null) {
                assert (this.right != null);
                this.left.toString(sb, depth + 1);
                this.right.toString(sb, depth + 1);
            }
        }
    }

    private static final class InclusiveRange {
        public final long start;
        public final long end;

        public InclusiveRange(long start, long end) {
            assert (end >= start);
            this.start = start;
            this.end = end;
        }

        public String toString() {
            return this.start + " to " + this.end;
        }
    }
}

