/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.kylin.jdbc.KylinConnection;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaUtils;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.MetaImpl;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.MissingResultsException;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.QueryState;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.TypedValue;

public class KylinMeta
extends MetaImpl {
    private KMetaProject metaProject;
    private static final List<MetaImpl.MetaTableType> metaTableTypes = new ArrayList<MetaImpl.MetaTableType>();

    public KylinMeta(KylinConnection connection) {
        super(connection);
    }

    private KylinConnection connection() {
        return (KylinConnection)this.connection;
    }

    @Override
    public Meta.StatementHandle prepare(Meta.ConnectionHandle ch, String sql, long maxRowCount) {
        Meta.StatementHandle result = super.createStatement(ch);
        result.signature = this.connection().mockPreparedSignature(sql);
        return result;
    }

    @Override
    public Meta.ExecuteBatchResult prepareAndExecuteBatch(Meta.StatementHandle sh, List<String> sqlCommands) throws NoSuchStatementException {
        return new Meta.ExecuteBatchResult(new long[0]);
    }

    @Override
    public Meta.ExecuteBatchResult executeBatch(Meta.StatementHandle sh, List<List<TypedValue>> parameterValues) throws NoSuchStatementException {
        return new Meta.ExecuteBatchResult(new long[0]);
    }

    @Override
    @Deprecated
    public Meta.ExecuteResult execute(Meta.StatementHandle sh, List<TypedValue> parameterValues, long maxRowCount) throws NoSuchStatementException {
        Meta.MetaResultSet metaResultSet = Meta.MetaResultSet.create(sh.connectionId, sh.id, false, sh.signature, null);
        return new Meta.ExecuteResult(Collections.singletonList(metaResultSet));
    }

    @Override
    public Meta.ExecuteResult execute(Meta.StatementHandle sh, List<TypedValue> parameterValues, int maxRowsInFirstFrame) throws NoSuchStatementException {
        Meta.MetaResultSet metaResultSet = Meta.MetaResultSet.create(sh.connectionId, sh.id, false, sh.signature, null);
        return new Meta.ExecuteResult(Collections.singletonList(metaResultSet));
    }

    @Override
    @Deprecated
    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle sh, String sql, long maxRowCount, Meta.PrepareCallback callback) {
        return this.getPreparedExecuteResult(sh, sql, callback);
    }

    @Override
    public Meta.ExecuteResult prepareAndExecute(Meta.StatementHandle sh, String sql, long maxRowCount, int maxRowsInFirstFrame, Meta.PrepareCallback callback) throws NoSuchStatementException {
        return this.getPreparedExecuteResult(sh, sql, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Meta.ExecuteResult getPreparedExecuteResult(Meta.StatementHandle sh, String sql, Meta.PrepareCallback callback) {
        try {
            Object object = callback.getMonitor();
            synchronized (object) {
                callback.clear();
                sh.signature = this.connection().mockPreparedSignature(sql);
                callback.assign(sh.signature, null, -1L);
            }
            callback.execute();
            Meta.MetaResultSet metaResultSet = Meta.MetaResultSet.create(sh.connectionId, sh.id, false, sh.signature, null);
            return new Meta.ExecuteResult(Collections.singletonList(metaResultSet));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void closeStatement(Meta.StatementHandle h) {
    }

    private KMetaProject getMetaProject() {
        try {
            if (this.metaProject == null) {
                KylinConnection conn = this.connection();
                this.metaProject = conn.getRemoteClient().retrieveMetaData(conn.getProject());
            }
            return this.metaProject;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Meta.MetaResultSet getTableTypes(Meta.ConnectionHandle ch) {
        return this.createResultSet(metaTableTypes, MetaImpl.MetaTableType.class, "TABLE_TYPE");
    }

    @Override
    public Meta.MetaResultSet getCatalogs(Meta.ConnectionHandle ch) {
        List<KMetaCatalog> catalogs = this.getMetaProject().catalogs;
        return this.createResultSet(catalogs, KMetaCatalog.class, "TABLE_CAT");
    }

    @Override
    public Meta.MetaResultSet getSchemas(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern) {
        List<KMetaSchema> schemas = this.getMetaProject().getSchemas(catalog, schemaPattern);
        return this.createResultSet(schemas, KMetaSchema.class, "TABLE_SCHEM", "TABLE_CATALOG");
    }

    @Override
    public Meta.MetaResultSet getTables(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        List<KMetaTable> tables = this.getMetaProject().getTables(catalog, schemaPattern, tableNamePattern, typeList);
        return this.createResultSet(tables, KMetaTable.class, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION");
    }

    @Override
    public Meta.MetaResultSet getColumns(Meta.ConnectionHandle ch, String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        List<KMetaColumn> columns = this.getMetaProject().getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        return this.createResultSet(columns, KMetaColumn.class, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN");
    }

    private Meta.MetaResultSet createResultSet(List iterable, Class clazz, String ... names) {
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String name : names) {
            Field field;
            int index = fields.size();
            String fieldName = AvaticaUtils.toCamelCase(name);
            try {
                field = clazz.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            columns.add(KylinMeta.columnMetaData(name, index, field.getType(), true));
            fields.add(field);
            fieldNames.add(fieldName);
        }
        Meta.CursorFactory cursorFactory = Meta.CursorFactory.record(clazz, fields, fieldNames);
        Meta.Signature signature = new Meta.Signature(columns, "", null, Collections.emptyMap(), cursorFactory, Meta.StatementType.SELECT);
        Meta.StatementHandle sh = this.createStatement(this.connection().handle);
        Meta.Frame frame = new Meta.Frame(0L, true, iterable);
        return Meta.MetaResultSet.create(this.connection().id, sh.id, true, signature, frame);
    }

    public static List<? extends NamedWithChildren> searchByPatterns(NamedWithChildren parent, Meta.Pat ... patterns) {
        assert (patterns != null && patterns.length > 0);
        List<? extends NamedWithChildren> children = KylinMeta.findChildren(parent, patterns[0]);
        if (patterns.length == 1) {
            return children;
        }
        ArrayList<? extends NamedWithChildren> result = new ArrayList<NamedWithChildren>();
        Meta.Pat[] subPatterns = Arrays.copyOfRange(patterns, 1, patterns.length);
        for (NamedWithChildren namedWithChildren : children) {
            result.addAll(KylinMeta.searchByPatterns(namedWithChildren, subPatterns));
        }
        return result;
    }

    private static List<? extends NamedWithChildren> findChildren(NamedWithChildren parent, Meta.Pat pattern) {
        if (null == pattern.s || pattern.s.equals("%")) {
            return parent.getChildren();
        }
        ArrayList<NamedWithChildren> result = new ArrayList<NamedWithChildren>();
        Pattern regex = KylinMeta.likeToRegex(pattern);
        for (NamedWithChildren namedWithChildren : parent.getChildren()) {
            if (!regex.matcher(namedWithChildren.getName()).matches()) continue;
            result.add(namedWithChildren);
        }
        return result;
    }

    private static Pattern likeToRegex(Meta.Pat pattern) {
        StringBuilder buf = new StringBuilder("^");
        char[] charArray = pattern.s.toCharArray();
        int slash = -2;
        block6: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (slash == i - 1) {
                buf.append('[').append(c).append(']');
                continue;
            }
            switch (c) {
                case '\\': {
                    slash = i;
                    continue block6;
                }
                case '%': {
                    buf.append(".*");
                    continue block6;
                }
                case '[': {
                    buf.append("\\[");
                    continue block6;
                }
                case ']': {
                    buf.append("\\]");
                    continue block6;
                }
                default: {
                    buf.append('[').append(c).append(']');
                }
            }
        }
        buf.append("$");
        return Pattern.compile(buf.toString());
    }

    @Override
    public Meta.Frame fetch(Meta.StatementHandle h, long offset, int fetchMaxRowCount) throws NoSuchStatementException, MissingResultsException {
        return null;
    }

    @Override
    public boolean syncResults(Meta.StatementHandle sh, QueryState state, long offset) throws NoSuchStatementException {
        return false;
    }

    @Override
    public void commit(Meta.ConnectionHandle ch) {
    }

    @Override
    public void rollback(Meta.ConnectionHandle ch) {
    }

    static {
        metaTableTypes.add(new MetaImpl.MetaTableType("TABLE"));
    }

    public static class KMetaColumn
    extends MetaImpl.MetaColumn
    implements NamedWithChildren {
        public KMetaColumn(String tableCat, String tableSchem, String tableName, String columnName, int dataType, String typeName, int columnSize, Integer decimalDigits, int numPrecRadix, int nullable, int charOctetLength, int ordinalPosition, String isNullable) {
            super(tableCat, tableSchem, tableName, columnName, dataType, typeName, columnSize, decimalDigits, numPrecRadix, nullable, charOctetLength, ordinalPosition, isNullable);
        }

        public List<NamedWithChildren> getChildren() {
            return Collections.emptyList();
        }
    }

    public static class KMetaTable
    extends MetaImpl.MetaTable
    implements NamedWithChildren {
        public final List<KMetaColumn> columns;

        public KMetaTable(String tableCat, String tableSchem, String tableName, String tableType, List<KMetaColumn> columns) {
            super(tableCat, tableSchem, tableName, tableType);
            this.columns = columns;
        }

        @Override
        public List<? extends NamedWithChildren> getChildren() {
            return this.columns;
        }
    }

    public static class KMetaSchema
    extends MetaImpl.MetaSchema
    implements NamedWithChildren {
        public final List<KMetaTable> tables;

        public KMetaSchema(String tableCatalog, String tableSchem, List<KMetaTable> tables) {
            super(tableCatalog, tableSchem);
            this.tables = tables;
        }

        @Override
        public List<? extends NamedWithChildren> getChildren() {
            return this.tables;
        }
    }

    public static class KMetaCatalog
    implements NamedWithChildren {
        public final String tableCat;
        public final List<KMetaSchema> schemas;

        public KMetaCatalog(String tableCatalog, List<KMetaSchema> schemas) {
            this.tableCat = tableCatalog;
            this.schemas = schemas;
        }

        @Override
        public String getName() {
            return this.tableCat;
        }

        @Override
        public List<? extends NamedWithChildren> getChildren() {
            return this.schemas;
        }
    }

    public static class KMetaProject
    implements NamedWithChildren {
        public final String projectName;
        public final List<KMetaCatalog> catalogs;

        public KMetaProject(String projectName, List<KMetaCatalog> catalogs) {
            this.projectName = projectName;
            this.catalogs = catalogs;
        }

        public List<KMetaSchema> getSchemas(String catalog, Meta.Pat schemaPattern) {
            return KylinMeta.searchByPatterns(this, Meta.Pat.of(catalog), schemaPattern);
        }

        public List<KMetaTable> getTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
            return KylinMeta.searchByPatterns(this, Meta.Pat.of(catalog), schemaPattern, tableNamePattern);
        }

        public List<KMetaColumn> getColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
            return KylinMeta.searchByPatterns(this, Meta.Pat.of(catalog), schemaPattern, tableNamePattern, columnNamePattern);
        }

        @Override
        public String getName() {
            return this.projectName;
        }

        @Override
        public List<? extends NamedWithChildren> getChildren() {
            return this.catalogs;
        }
    }

    public static interface NamedWithChildren
    extends MetaImpl.Named {
        public List<? extends NamedWithChildren> getChildren();
    }
}

