/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server;
import kafka.server.Server$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Mx4jLoader$;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tec\u0001\u0002\u001d:\u0001yB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"A\u0001\r\u0001B\u0001B\u0003%\u0011\rC\u0003p\u0001\u0011\u0005\u0001\u000f\u0003\u0006v\u0001A\u0005\t1!Q\u0001\nYD\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\t\u000f\u0005%\u0001\u0001)A\u0005s\"I\u00111\u0002\u0001C\u0002\u0013%\u0011Q\u0002\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003}\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002 \u0001\u0001\u000b\u0011BA\u000b\u0011%\t\t\u0003\u0001b\u0001\n\u0013\t\u0019\u0003\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA\u0013\u0011%\t\u0019\u0007\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u0002~\u0001\u0001\u000b\u0011BA4\u0011%\ty\b\u0001b\u0001\n\u0013\t\t\t\u0003\u0005\u0002\f\u0002\u0001\u000b\u0011BAB\u0011%\ti\t\u0001b\u0001\n\u0013\ty\t\u0003\u0005\u0002\u001a\u0002\u0001\u000b\u0011BAI\u0011\u001d\tY\n\u0001C!\u0003;Cq!!*\u0001\t\u0003\ni\nC\u0004\u0002(\u0002!\t%!(\b\u000f\u0005%\u0016\b#\u0001\u0002,\u001a1\u0001(\u000fE\u0001\u0003[Caa\u001c\r\u0005\u0002\u0005=\u0006\"CAY1\t\u0007I\u0011AAZ\u0011!\tI\f\u0007Q\u0001\n\u0005U\u0006\"CA^1\t\u0007I\u0011AA_\u0011!\t9\r\u0007Q\u0001\n\u0005}\u0006\"CAe1\t\u0007I\u0011AAf\u0011!\t\u0019\u000e\u0007Q\u0001\n\u00055g!CAk1A\u0005\u0019\u0013EAl\u000f\u001d\u0011y\u0005\u0007EA\u0003{4q!a7\u0019\u0011\u0003\u000bi\u000e\u0003\u0004pE\u0011\u0005\u00111 \u0005\n\u0003\u007f\u0014\u0013\u0011!C!\u0003gC\u0011B!\u0001#\u0003\u0003%\tAa\u0001\t\u0013\t-!%!A\u0005\u0002\t5\u0001\"\u0003B\fE\u0005\u0005I\u0011\tB\r\u0011%\u0011\tCIA\u0001\n\u0003\u0011\u0019\u0003C\u0005\u0003.\t\n\t\u0011\"\u0011\u00030!I!\u0011\u0007\u0012\u0002\u0002\u0013\u0005#1\u0007\u0005\n\u0005k\u0011\u0013\u0011!C\u0005\u0005o9qA!\u0015\u0019\u0011\u0003\u0013)EB\u0004\u0003@aA\tI!\u0011\t\r=lC\u0011\u0001B\"\u0011%\ty0LA\u0001\n\u0003\n\u0019\fC\u0005\u0003\u00025\n\t\u0011\"\u0001\u0003\u0004!I!1B\u0017\u0002\u0002\u0013\u0005!q\t\u0005\n\u0005/i\u0013\u0011!C!\u00053A\u0011B!\t.\u0003\u0003%\tAa\u0013\t\u0013\t5R&!A\u0005B\t=\u0002\"\u0003B\u0019[\u0005\u0005I\u0011\tB\u001a\u0011%\u0011)$LA\u0001\n\u0013\u00119\u0004C\u0004\u0003Ta!\tA!\u0016\u0003\u001f-\u000bgm[1SC\u001a$8+\u001a:wKJT!AO\u001e\u0002\rM,'O^3s\u0015\u0005a\u0014!B6bM.\f7\u0001A\n\u0005\u0001}*\u0015\n\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015I\u0001\u0004B]f\u0014VM\u001a\t\u0003\r\u001ek\u0011!O\u0005\u0003\u0011f\u0012aaU3sm\u0016\u0014\bC\u0001&N\u001b\u0005Y%B\u0001'<\u0003\u0015)H/\u001b7t\u0013\tq5JA\u0004M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\t1\u0015+\u0003\u0002Ss\tY1*\u00194lC\u000e{gNZ5h\u0003\u0011!\u0018.\\3\u0011\u0005UsV\"\u0001,\u000b\u00051;&B\u0001-Z\u0003\u0019\u0019w.\\7p]*\u0011AH\u0017\u0006\u00037r\u000ba!\u00199bG\",'\"A/\u0002\u0007=\u0014x-\u0003\u0002`-\n!A+[7f\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010E\u0002AE\u0012L!aY!\u0003\r=\u0003H/[8o!\t)GN\u0004\u0002gUB\u0011q-Q\u0007\u0002Q*\u0011\u0011.P\u0001\u0007yI|w\u000e\u001e \n\u0005-\f\u0015A\u0002)sK\u0012,g-\u0003\u0002n]\n11\u000b\u001e:j]\u001eT!a[!\u0002\rqJg.\u001b;?)\u0011\t(o\u001d;\u0011\u0005\u0019\u0003\u0001\"B(\u0005\u0001\u0004\u0001\u0006\"B*\u0005\u0001\u0004!\u0006\"\u00021\u0005\u0001\u0004\t\u0017a\u0001=%cA!\u0001i^=}\u0013\tA\u0018I\u0001\u0004UkBdWM\r\t\u0003\rjL!a_\u001d\u0003\u001d5+G/\u0019)s_B,'\u000f^5fgB!Q0!\u0001e\u001b\u0005q(BA@B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u0007q(aA*fc\u0006IQ.\u001a;b!J|\u0007o]\u000b\u0002s\u0006QQ.\u001a;b!J|\u0007o\u001d\u0011\u0002\u0017=4g\r\\5oK\u0012K'o]\u000b\u0002y\u0006aqN\u001a4mS:,G)\u001b:tA\u00059Q.\u001a;sS\u000e\u001cXCAA\u000b!\u0011\t9\"a\u0007\u000e\u0005\u0005e!bAA\t/&!\u0011QDA\r\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u001dG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:f+\t\t)\u0003\u0005\u0004\u0002(\u0005U\u0012\u0011H\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005=\u0012\u0011G\u0001\u0005kRLGN\u0003\u0002\u00024\u0005!!.\u0019<b\u0013\u0011\t9$!\u000b\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0005\u0002<\u0005u\u0012\u0011IA'\u001b\t\ti#\u0003\u0003\u0002@\u00055\"aA'baB!\u00111IA%\u001b\t\t)E\u0003\u0003\u0002H\u0005E\u0012\u0001\u00027b]\u001eLA!a\u0013\u0002F\t9\u0011J\u001c;fO\u0016\u0014\b\u0003BA(\u00037rA!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+J\u0016\u0001\u0002:bMRLA!!\u0017\u0002T\u0005Q!+\u00194u\u0007>tg-[4\n\t\u0005u\u0013q\f\u0002\f\u0003\u0012$'/Z:t'B,7M\u0003\u0003\u0002Z\u0005M\u0013!H2p]R\u0014x\u000e\u001c7feF+xN];n->$XM]:GkR,(/\u001a\u0011\u0002\u0017I\fg\r^'b]\u0006<WM]\u000b\u0003\u0003O\u0002b!!\u001b\u0002n\u0005ETBAA6\u0015\r\t)fO\u0005\u0005\u0003_\nYG\u0001\tLC\u001a\\\u0017MU1gi6\u000bg.Y4feB!\u00111OA=\u001b\t\t)HC\u0002Y\u0003oR!AO-\n\t\u0005m\u0014Q\u000f\u0002\u0015\u0003BLW*Z:tC\u001e,\u0017I\u001c3WKJ\u001c\u0018n\u001c8\u0002\u0019I\fg\r^'b]\u0006<WM\u001d\u0011\u0002\r\t\u0014xn[3s+\t\t\u0019\t\u0005\u0003AE\u0006\u0015\u0005c\u0001$\u0002\b&\u0019\u0011\u0011R\u001d\u0003\u0019\t\u0013xn[3s'\u0016\u0014h/\u001a:\u0002\u000f\t\u0014xn[3sA\u0005Q1m\u001c8ue>dG.\u001a:\u0016\u0005\u0005E\u0005\u0003\u0002!c\u0003'\u00032ARAK\u0013\r\t9*\u000f\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJ\f1bY8oiJ|G\u000e\\3sA\u000591\u000f^1siV\u0004HCAAP!\r\u0001\u0015\u0011U\u0005\u0004\u0003G\u000b%\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8\u0002\u001f-\u000bgm[1SC\u001a$8+\u001a:wKJ\u0004\"A\u0012\r\u0014\u0005ayDCAAV\u00035iU\r^1eCR\fGk\u001c9jGV\u0011\u0011Q\u0017\t\u0005\u0003\u0007\n9,C\u0002n\u0003\u000b\na\"T3uC\u0012\fG/\u0019+pa&\u001c\u0007%A\tNKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:,\"!a0\u0011\t\u0005\u0005\u00171Y\u0007\u0002/&\u0019\u0011QY,\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0011R*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8!\u0003=iU\r^1eCR\fGk\u001c9jG&#WCAAg!\u0011\t\t-a4\n\u0007\u0005EwK\u0001\u0003Vk&$\u0017\u0001E'fi\u0006$\u0017\r^1U_BL7-\u00133!\u0005-\u0001&o\\2fgN\u0014v\u000e\\3\u0014\u0005\u0001z\u0014f\u0001\u0011#[\tQ!I]8lKJ\u0014v\u000e\\3\u0014\u0011\tz\u0014q\\Ar\u0003S\u00042!!9!\u001b\u0005A\u0002c\u0001!\u0002f&\u0019\u0011q]!\u0003\u000fA\u0013x\u000eZ;diB!\u00111^A{\u001d\u0011\ti/!=\u000f\u0007\u001d\fy/C\u0001C\u0013\r\t\u00190Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t90!?\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u0005M\u0018\t\u0006\u0002\u0002~B\u0019\u0011\u0011\u001d\u0012\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011)\u0001E\u0002A\u0005\u000fI1A!\u0003B\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011yA!\u0006\u0011\u0007\u0001\u0013\t\"C\u0002\u0003\u0014\u0005\u00131!\u00118z\u0011!)h%!AA\u0002\t\u0015\u0011a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tm\u0001#B?\u0003\u001e\t=\u0011b\u0001B\u0010}\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011)Ca\u000b\u0011\u0007\u0001\u00139#C\u0002\u0003*\u0005\u0013qAQ8pY\u0016\fg\u000e\u0003\u0005vQ\u0005\u0005\t\u0019\u0001B\b\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u0003\u0003!!xn\u0015;sS:<GCAA[\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011I\u0004\u0005\u0003\u0002D\tm\u0012\u0002\u0002B\u001f\u0003\u000b\u0012aa\u00142kK\u000e$(AD\"p]R\u0014x\u000e\u001c7feJ{G.Z\n\t[}\ny.a9\u0002jR\u0011!Q\t\t\u0004\u0003ClC\u0003\u0002B\b\u0005\u0013B\u0001\"^\u0019\u0002\u0002\u0003\u0007!Q\u0001\u000b\u0005\u0005K\u0011i\u0005\u0003\u0005vg\u0005\u0005\t\u0019\u0001B\b\u0003)\u0011%o\\6feJ{G.Z\u0001\u000f\u0007>tGO]8mY\u0016\u0014(k\u001c7f\u0003EIg.\u001b;jC2L'0\u001a'pO\u0012K'o\u001d\u000b\u0004m\n]\u0003\"B(8\u0001\u0004\u0001\u0006")
public class KafkaRaftServer
implements Server,
Logging {
    private final KafkaConfig config;
    private final Time time;
    private final /* synthetic */ Tuple2 x$1;
    private final MetaProperties metaProps;
    private final Seq<String> offlineDirs;
    private final Metrics metrics;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private final Option<BrokerServer> broker;
    private final Option<ControllerServer> controller;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<MetaProperties, Seq<String>> initializeLogDirs(KafkaConfig config) {
        return KafkaRaftServer$.MODULE$.initializeLogDirs(config);
    }

    public static Uuid MetadataTopicId() {
        return KafkaRaftServer$.MODULE$.MetadataTopicId();
    }

    public static TopicPartition MetadataPartition() {
        return KafkaRaftServer$.MODULE$.MetadataPartition();
    }

    public static String MetadataTopic() {
        return KafkaRaftServer$.MODULE$.MetadataTopic();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private MetaProperties metaProps() {
        return this.metaProps;
    }

    private Seq<String> offlineDirs() {
        return this.offlineDirs;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    private Option<BrokerServer> broker() {
        return this.broker;
    }

    private Option<ControllerServer> controller() {
        return this.controller;
    }

    @Override
    public void startup() {
        Mx4jLoader$.MODULE$.maybeLoad();
        this.raftManager().startup();
        this.controller().foreach((Function1 & Serializable)x$2 -> {
            x$2.startup();
            return BoxedUnit.UNIT;
        });
        this.broker().foreach((Function1 & Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        AppInfoParser.registerAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.config.brokerId()), (Metrics)this.metrics(), (long)this.time.milliseconds());
        this.info((Function0<String>)(Function0 & Serializable)() -> KafkaBroker$.MODULE$.STARTED_MESSAGE());
    }

    @Override
    public void shutdown() {
        this.broker().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.raftManager().shutdown();
        this.controller().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString($this.config.brokerId()), (Metrics)this.metrics()), this, Level.WARN);
    }

    @Override
    public void awaitShutdown() {
        this.broker().foreach((Function1 & Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$7 -> {
            x$7.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public KafkaRaftServer(KafkaConfig config, Time time, Option<String> threadNamePrefix) {
        this.config = config;
        this.time = time;
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(config.originals()));
        KafkaYammerMetrics.INSTANCE.configure(config.originals());
        Tuple2<MetaProperties, Seq<String>> tuple2 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MetaProperties metaProps = (MetaProperties)tuple2._1();
        Seq offlineDirs = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metaProps, (Object)offlineDirs);
        this.x$1 = tuple22;
        this.metaProps = (MetaProperties)this.x$1._1();
        this.offlineDirs = (Seq)this.x$1._2();
        this.metrics = Server$.MODULE$.initializeMetrics(config, time, this.metaProps().clusterId());
        this.controllerQuorumVotersFuture = CompletableFuture.completedFuture(RaftConfig.parseVoterConnections(config.quorumVoters()));
        this.raftManager = new KafkaRaftManager(this.metaProps(), config, new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), time, this.metrics(), threadNamePrefix, this.controllerQuorumVotersFuture());
        this.broker = config.processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$) ? new Some((Object)new BrokerServer(config, this.metaProps(), this.raftManager(), time, this.metrics(), threadNamePrefix, this.offlineDirs(), this.controllerQuorumVotersFuture(), Server$.MODULE$.SUPPORTED_FEATURES())) : None$.MODULE$;
        this.controller = config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$) ? new Some((Object)new ControllerServer(this.metaProps(), config, this.raftManager(), time, this.metrics(), threadNamePrefix, this.controllerQuorumVotersFuture())) : None$.MODULE$;
    }

    public static interface ProcessRole {
    }
}

