/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.Stamped;

public class PunctuationSchedule
extends Stamped<ProcessorNode> {
    private final long interval;
    private final Punctuator punctuator;
    private boolean isCancelled = false;
    private final RepointableCancellable cancellable;

    PunctuationSchedule(ProcessorNode node, long interval, Punctuator punctuator) {
        this(node, 0L, interval, punctuator, new RepointableCancellable());
        this.cancellable.setSchedule(this);
    }

    private PunctuationSchedule(ProcessorNode node, long time, long interval, Punctuator punctuator, RepointableCancellable cancellable) {
        super(node, time);
        this.interval = interval;
        this.punctuator = punctuator;
        this.cancellable = cancellable;
    }

    public ProcessorNode node() {
        return (ProcessorNode)this.value;
    }

    public Punctuator punctuator() {
        return this.punctuator;
    }

    public Cancellable cancellable() {
        return this.cancellable;
    }

    void markCancelled() {
        this.isCancelled = true;
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    public PunctuationSchedule next(long currTimestamp) {
        PunctuationSchedule nextSchedule = this.timestamp == 0L ? new PunctuationSchedule((ProcessorNode)this.value, currTimestamp + this.interval, this.interval, this.punctuator, this.cancellable) : new PunctuationSchedule((ProcessorNode)this.value, this.timestamp + this.interval, this.interval, this.punctuator, this.cancellable);
        this.cancellable.setSchedule(nextSchedule);
        return nextSchedule;
    }

    private static class RepointableCancellable
    implements Cancellable {
        private PunctuationSchedule schedule;

        private RepointableCancellable() {
        }

        synchronized void setSchedule(PunctuationSchedule schedule) {
            this.schedule = schedule;
        }

        @Override
        public synchronized void cancel() {
            this.schedule.markCancelled();
        }
    }
}

