/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.timeline;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.SnapshottableHashTable;

public class TimelineHashSet<T>
extends SnapshottableHashTable<TimelineHashSetEntry<T>>
implements Set<T> {
    public TimelineHashSet(SnapshotRegistry snapshotRegistry, int expectedSize) {
        super(snapshotRegistry, expectedSize);
    }

    @Override
    public int size() {
        return this.size(Long.MAX_VALUE);
    }

    public int size(long epoch) {
        return this.snapshottableSize(epoch);
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty(Long.MAX_VALUE);
    }

    public boolean isEmpty(long epoch) {
        return this.snapshottableSize(epoch) == 0;
    }

    @Override
    public boolean contains(Object key) {
        return this.contains(key, Long.MAX_VALUE);
    }

    public boolean contains(Object object, long epoch) {
        return this.snapshottableGet(new TimelineHashSetEntry<Object>(object), epoch) != null;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(Long.MAX_VALUE);
    }

    public Iterator<T> iterator(long epoch) {
        return new ValueIterator(epoch);
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        Iterator<T> iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i++] = iter.next();
        }
        return result;
    }

    @Override
    public <R> R[] toArray(R[] a) {
        int size = this.size();
        if (size <= a.length) {
            Iterator<T> iter = this.iterator();
            int i = 0;
            while (iter.hasNext()) {
                a[i++] = iter.next();
            }
            while (i < a.length) {
                a[i++] = null;
            }
            return a;
        }
        return this.toArray();
    }

    @Override
    public boolean add(T newValue) {
        Objects.requireNonNull(newValue);
        return this.snapshottableAddUnlessPresent(new TimelineHashSetEntry<T>(newValue));
    }

    @Override
    public boolean remove(Object value) {
        return this.snapshottableRemove(new TimelineHashSetEntry<Object>(value)) != null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object value : collection) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean modified = false;
        for (T value : collection) {
            if (!this.add(value)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        Objects.requireNonNull(collection);
        boolean modified = false;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            if (collection.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Objects.requireNonNull(collection);
        boolean modified = false;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            if (!collection.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        Iterator iter = this.snapshottableIterator(Long.MAX_VALUE);
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public int hashCode() {
        int hash = 0;
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            hash += iter.next().hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Collection c = (Collection)o;
        if (c.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(c);
        }
        catch (ClassCastException unused) {
            return false;
        }
    }

    final class ValueIterator
    implements Iterator<T> {
        private final Iterator<TimelineHashSetEntry<T>> iter;

        ValueIterator(long epoch) {
            this.iter = TimelineHashSet.this.snapshottableIterator(epoch);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.iter.next().value;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    static class TimelineHashSetEntry<T>
    implements SnapshottableHashTable.ElementWithStartEpoch {
        private final T value;
        private long startEpoch;

        TimelineHashSetEntry(T value) {
            this.value = value;
            this.startEpoch = Long.MAX_VALUE;
        }

        public T getValue() {
            return this.value;
        }

        @Override
        public void setStartEpoch(long startEpoch) {
            this.startEpoch = startEpoch;
        }

        @Override
        public long startEpoch() {
            return this.startEpoch;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TimelineHashSetEntry)) {
                return false;
            }
            TimelineHashSetEntry other = (TimelineHashSetEntry)o;
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

