/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class FeatureLevelRecord
implements ApiMessage {
    String name;
    short minFeatureLevel;
    short maxFeatureLevel;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The feature name."), new Field("min_feature_level", (Type)Type.INT16, "The current finalized minimum feature level of this feature for the cluster."), new Field("max_feature_level", (Type)Type.INT16, "The current finalized maximum feature level of this feature for the cluster.")});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public FeatureLevelRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public FeatureLevelRecord() {
        this.name = "";
        this.minFeatureLevel = 0;
        this.maxFeatureLevel = 0;
    }

    public short apiKey() {
        return 12;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version) {
        short length = _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field name was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field name had invalid length " + length);
        }
        this.name = _readable.readString((int)length);
        this.minFeatureLevel = _readable.readShort();
        this.maxFeatureLevel = _readable.readShort();
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.name);
        _writable.writeShort((short)_stringBytes.length);
        _writable.writeByteArray(_stringBytes);
        _writable.writeShort(this.minFeatureLevel);
        _writable.writeShort(this.maxFeatureLevel);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'name' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.name, _stringBytes);
        _size.addBytes(_stringBytes.length + 2);
        _size.addBytes(2);
        _size.addBytes(2);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureLevelRecord)) {
            return false;
        }
        FeatureLevelRecord other = (FeatureLevelRecord)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.minFeatureLevel != other.minFeatureLevel) {
            return false;
        }
        if (this.maxFeatureLevel != other.maxFeatureLevel) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
        hashCode = 31 * hashCode + this.minFeatureLevel;
        hashCode = 31 * hashCode + this.maxFeatureLevel;
        return hashCode;
    }

    public FeatureLevelRecord duplicate() {
        FeatureLevelRecord _duplicate = new FeatureLevelRecord();
        _duplicate.name = this.name;
        _duplicate.minFeatureLevel = this.minFeatureLevel;
        _duplicate.maxFeatureLevel = this.maxFeatureLevel;
        return _duplicate;
    }

    public String toString() {
        return "FeatureLevelRecord(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", minFeatureLevel=" + this.minFeatureLevel + ", maxFeatureLevel=" + this.maxFeatureLevel + ")";
    }

    public String name() {
        return this.name;
    }

    public short minFeatureLevel() {
        return this.minFeatureLevel;
    }

    public short maxFeatureLevel() {
        return this.maxFeatureLevel;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public FeatureLevelRecord setName(String v) {
        this.name = v;
        return this;
    }

    public FeatureLevelRecord setMinFeatureLevel(short v) {
        this.minFeatureLevel = v;
        return this;
    }

    public FeatureLevelRecord setMaxFeatureLevel(short v) {
        this.maxFeatureLevel = v;
        return this;
    }
}

