/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Objects;

public abstract class ApplicationEvent {
    private final Type type;

    protected ApplicationEvent(Type type) {
        this.type = Objects.requireNonNull(type);
    }

    public Type type() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationEvent that = (ApplicationEvent)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    protected String toStringBase() {
        return "type=" + (Object)((Object)this.type);
    }

    public String toString() {
        return "ApplicationEvent{" + this.toStringBase() + '}';
    }

    public static enum Type {
        COMMIT,
        POLL,
        FETCH_COMMITTED_OFFSETS,
        NEW_TOPICS_METADATA_UPDATE,
        ASSIGNMENT_CHANGE,
        LIST_OFFSETS,
        RESET_POSITIONS,
        VALIDATE_POSITIONS,
        TOPIC_METADATA,
        SUBSCRIPTION_CHANGE,
        UNSUBSCRIBE,
        CONSUMER_REBALANCE_LISTENER_CALLBACK_COMPLETED,
        COMMIT_ON_CLOSE,
        LEAVE_ON_CLOSE;

    }
}

