/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.openjdk.jol.info.ClassLayout;

public class ColumnBuilderStatus {
    public static final int INSTANCE_SIZE = ColumnBuilderStatus.deepInstanceSize(ColumnBuilderStatus.class);
    private final TsBlockBuilderStatus tsBlockBuilderStatus;
    private int currentSize;

    public ColumnBuilderStatus(TsBlockBuilderStatus tsBlockBuilderStatus) {
        this.tsBlockBuilderStatus = Objects.requireNonNull(tsBlockBuilderStatus, "tsBlockBuilderStatus must not be null");
    }

    public int getMaxTsBlockSizeInBytes() {
        return this.tsBlockBuilderStatus.getMaxTsBlockSizeInBytes();
    }

    public void addBytes(int bytes) {
        this.currentSize += bytes;
        this.tsBlockBuilderStatus.addBytes(bytes);
    }

    public String toString() {
        return "ColumnBuilderStatus{, currentSize=" + this.currentSize + '}';
    }

    private static int deepInstanceSize(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException(String.format("Cannot determine size of %s because it contains an array", clazz.getSimpleName()));
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException(String.format("%s is an interface", clazz.getSimpleName()));
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException(String.format("%s is abstract", clazz.getSimpleName()));
        }
        if (!clazz.getSuperclass().equals(Object.class)) {
            throw new IllegalArgumentException(String.format("Cannot determine size of a subclass. %s extends from %s", clazz.getSimpleName(), clazz.getSuperclass().getSimpleName()));
        }
        int size = ClassLayout.parseClass(clazz).instanceSize();
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive() || field.isSynthetic()) continue;
            size += ColumnBuilderStatus.deepInstanceSize(field.getType());
        }
        return size;
    }
}

