/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary.fast;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazyBinaryDeserializeRead
extends DeserializeRead {
    public static final Logger LOG = LoggerFactory.getLogger((String)LazyBinaryDeserializeRead.class.getName());
    private byte[] bytes;
    private int start;
    private int offset;
    private int end;
    private int fieldCount;
    private int fieldIndex;
    private byte nullByte;
    private LazyBinaryUtils.VInt tempVInt;
    private LazyBinaryUtils.VLong tempVLong;
    private boolean readBeyondConfiguredFieldsWarned;
    private boolean readBeyondBufferRangeWarned;
    private boolean bufferRangeHasExtraDataWarned;

    public LazyBinaryDeserializeRead(TypeInfo[] typeInfos) {
        super(typeInfos);
        this.fieldCount = typeInfos.length;
        this.tempVInt = new LazyBinaryUtils.VInt();
        this.tempVLong = new LazyBinaryUtils.VLong();
        this.readBeyondConfiguredFieldsWarned = false;
        this.readBeyondBufferRangeWarned = false;
        this.bufferRangeHasExtraDataWarned = false;
    }

    private LazyBinaryDeserializeRead() {
    }

    @Override
    public void set(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.start = offset;
        this.end = offset + length;
        this.fieldIndex = 0;
    }

    @Override
    public boolean readCheckNull() throws IOException {
        boolean isNull;
        if (this.fieldIndex >= this.fieldCount) {
            if (!this.readBeyondConfiguredFieldsWarned) {
                LOG.info("Reading beyond configured fields! Configured " + this.fieldCount + " fields but " + " reading more (NULLs returned).  Ignoring similar problems.");
                this.readBeyondConfiguredFieldsWarned = true;
            }
            return true;
        }
        if (this.fieldIndex == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        if ((this.nullByte & 1 << this.fieldIndex % 8) == 0) {
            isNull = true;
        } else {
            isNull = false;
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            switch (this.primitiveCategories[this.fieldIndex]) {
                case BOOLEAN: {
                    this.currentBoolean = this.bytes[this.offset++] != 0;
                    break;
                }
                case BYTE: {
                    this.currentByte = this.bytes[this.offset++];
                    break;
                }
                case SHORT: {
                    if (this.offset + 2 > this.end) {
                        this.warnBeyondEof();
                    }
                    this.currentShort = LazyBinaryUtils.byteArrayToShort(this.bytes, this.offset);
                    this.offset += 2;
                    break;
                }
                case INT: {
                    LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                    this.offset += this.tempVInt.length;
                    if (this.offset > this.end) {
                        this.warnBeyondEof();
                    }
                    this.currentInt = this.tempVInt.value;
                    break;
                }
                case LONG: {
                    LazyBinaryUtils.readVLong(this.bytes, this.offset, this.tempVLong);
                    this.offset += this.tempVLong.length;
                    if (this.offset > this.end) {
                        this.warnBeyondEof();
                    }
                    this.currentLong = this.tempVLong.value;
                    break;
                }
                case FLOAT: {
                    if (this.offset + 4 > this.end) {
                        this.warnBeyondEof();
                    }
                    this.currentFloat = Float.intBitsToFloat(LazyBinaryUtils.byteArrayToInt(this.bytes, this.offset));
                    this.offset += 4;
                    break;
                }
                case DOUBLE: {
                    if (this.offset + 8 > this.end) {
                        this.warnBeyondEof();
                    }
                    this.currentDouble = Double.longBitsToDouble(LazyBinaryUtils.byteArrayToLong(this.bytes, this.offset));
                    this.offset += 8;
                    break;
                }
                case BINARY: 
                case STRING: 
                case CHAR: 
                case VARCHAR: {
                    LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                    this.offset += this.tempVInt.length;
                    if (this.offset > this.end) {
                        this.warnBeyondEof();
                    }
                    int saveStart = this.offset;
                    int length = this.tempVInt.value;
                    this.offset += length;
                    if (this.offset > this.end) {
                        this.warnBeyondEof();
                    }
                    this.currentBytes = this.bytes;
                    this.currentBytesStart = saveStart;
                    this.currentBytesLength = length;
                    break;
                }
                case DATE: {
                    LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                    this.offset += this.tempVInt.length;
                    if (this.offset > this.end) {
                        this.warnBeyondEof();
                    }
                    this.currentDateWritable.set(this.tempVInt.value);
                    break;
                }
                case TIMESTAMP: {
                    int length = TimestampWritable.getTotalLength(this.bytes, this.offset);
                    int saveStart = this.offset;
                    this.offset += length;
                    if (this.offset > this.end) {
                        this.warnBeyondEof();
                    }
                    this.currentTimestampWritable.set(this.bytes, saveStart);
                    break;
                }
                case INTERVAL_YEAR_MONTH: {
                    LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                    this.offset += this.tempVInt.length;
                    if (this.offset > this.end) {
                        this.warnBeyondEof();
                    }
                    this.currentHiveIntervalYearMonthWritable.set(this.tempVInt.value);
                    break;
                }
                case INTERVAL_DAY_TIME: {
                    LazyBinaryUtils.readVLong(this.bytes, this.offset, this.tempVLong);
                    this.offset += this.tempVLong.length;
                    if (this.offset >= this.end) {
                        this.warnBeyondEof();
                    }
                    LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                    this.offset += this.tempVInt.length;
                    if (this.offset > this.end) {
                        this.warnBeyondEof();
                    }
                    this.currentHiveIntervalDayTimeWritable.set(this.tempVLong.value, this.tempVInt.value);
                    break;
                }
                case DECIMAL: {
                    LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                    int saveStart = this.offset;
                    this.offset += this.tempVInt.length;
                    if (this.offset >= this.end) {
                        this.warnBeyondEof();
                    }
                    LazyBinaryUtils.readVInt(this.bytes, this.offset, this.tempVInt);
                    this.offset += this.tempVInt.length;
                    if (this.offset >= this.end) {
                        this.warnBeyondEof();
                    }
                    this.offset += this.tempVInt.value;
                    if (this.offset > this.end) {
                        this.warnBeyondEof();
                    }
                    int length = this.offset - saveStart;
                    LazyBinarySerDe.setFromBytes(this.bytes, saveStart, length, this.currentHiveDecimalWritable);
                    DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)this.typeInfos[this.fieldIndex];
                    int precision = decimalTypeInfo.getPrecision();
                    int scale = decimalTypeInfo.getScale();
                    HiveDecimal decimal = this.currentHiveDecimalWritable.getHiveDecimal(precision, scale);
                    if (decimal == null) {
                        isNull = true;
                        break;
                    }
                    this.currentHiveDecimalWritable.set(decimal);
                    break;
                }
                default: {
                    throw new Error("Unexpected primitive category " + this.primitiveCategories[this.fieldIndex].name());
                }
            }
            if (this.columnsToInclude != null && !this.columnsToInclude[this.fieldIndex]) {
                isNull = true;
            }
        }
        ++this.fieldIndex;
        if (this.fieldIndex < this.fieldCount && this.fieldIndex % 8 == 0) {
            if (this.offset >= this.end) {
                this.warnBeyondEof();
            }
            this.nullByte = this.bytes[this.offset++];
        }
        return isNull;
    }

    @Override
    public void extraFieldsCheck() {
        if (this.offset < this.end && !this.bufferRangeHasExtraDataWarned) {
            int length = this.end - this.start;
            int remaining = this.end - this.offset;
            LOG.info("Not all fields were read in the buffer range! Buffer range " + this.start + " for length " + length + " but " + remaining + " bytes remain. " + "(total buffer length " + this.bytes.length + ")" + "  Ignoring similar problems.");
            this.bufferRangeHasExtraDataWarned = true;
        }
    }

    @Override
    public boolean readBeyondConfiguredFieldsWarned() {
        return this.readBeyondConfiguredFieldsWarned;
    }

    @Override
    public boolean readBeyondBufferRangeWarned() {
        return this.readBeyondBufferRangeWarned;
    }

    @Override
    public boolean bufferRangeHasExtraDataWarned() {
        return this.bufferRangeHasExtraDataWarned;
    }

    private void warnBeyondEof() throws EOFException {
        if (!this.readBeyondBufferRangeWarned) {
            int length = this.end - this.start;
            LOG.info("Reading beyond buffer range! Buffer range " + this.start + " for length " + length + " but reading more... " + "(total buffer length " + this.bytes.length + ")" + "  Ignoring similar problems.");
            this.readBeyondBufferRangeWarned = true;
        }
    }
}

