/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.FullMapEqualComparer;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapEqualComparer;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.StringUtils;

public final class ObjectInspectorUtils {
    protected static final Log LOG = LogFactory.getLog((String)ObjectInspectorUtils.class.getName());

    public static ObjectInspector getWritableObjectInspector(ObjectInspector oi) {
        PrimitiveObjectInspector poi;
        if (oi.getCategory() == ObjectInspector.Category.PRIMITIVE && !((poi = (PrimitiveObjectInspector)oi) instanceof AbstractPrimitiveWritableObjectInspector)) {
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(poi);
        }
        return oi;
    }

    public static ObjectInspector getStandardObjectInspector(ObjectInspector oi) {
        return ObjectInspectorUtils.getStandardObjectInspector(oi, ObjectInspectorCopyOption.DEFAULT);
    }

    public static ObjectInspector getStandardObjectInspector(ObjectInspector oi, ObjectInspectorCopyOption objectInspectorOption) {
        ObjectInspector result = null;
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                switch (objectInspectorOption) {
                    case DEFAULT: {
                        if (poi.preferWritable()) {
                            result = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(poi);
                            break;
                        }
                        result = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(poi);
                        break;
                    }
                    case JAVA: {
                        result = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(poi);
                        break;
                    }
                    case WRITABLE: {
                        result = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(poi);
                    }
                }
                break;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                result = ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorUtils.getStandardObjectInspector(loi.getListElementObjectInspector(), objectInspectorOption));
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                result = ObjectInspectorFactory.getStandardMapObjectInspector(ObjectInspectorUtils.getStandardObjectInspector(moi.getMapKeyObjectInspector(), objectInspectorOption), ObjectInspectorUtils.getStandardObjectInspector(moi.getMapValueObjectInspector(), objectInspectorOption));
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
                ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fields.size());
                for (StructField structField : fields) {
                    fieldNames.add(structField.getFieldName());
                    fieldObjectInspectors.add(ObjectInspectorUtils.getStandardObjectInspector(structField.getFieldObjectInspector(), objectInspectorOption));
                }
                result = ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldObjectInspectors);
                break;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
                for (ObjectInspector eoi : uoi.getObjectInspectors()) {
                    ois.add(ObjectInspectorUtils.getStandardObjectInspector(eoi, objectInspectorOption));
                }
                result = ObjectInspectorFactory.getStandardUnionObjectInspector(ois);
                break;
            }
            default: {
                throw new RuntimeException("Unknown ObjectInspector category!");
            }
        }
        return result;
    }

    public static void partialCopyToStandardObject(List<Object> result, Object row, int startCol, int numCols, StructObjectInspector soi, ObjectInspectorCopyOption objectInspectorOption) {
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        int i = 0;
        int j = 0;
        for (StructField structField : fields) {
            if (i++ < startCol) continue;
            result.add(ObjectInspectorUtils.copyToStandardObject(soi.getStructFieldData(row, structField), structField.getFieldObjectInspector(), objectInspectorOption));
            if (++j != numCols) continue;
            break;
        }
    }

    public static void copyToStandardObject(List<Object> result, Object row, StructObjectInspector soi, ObjectInspectorCopyOption objectInspectorOption) {
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        for (StructField structField : fields) {
            result.add(ObjectInspectorUtils.copyToStandardObject(soi.getStructFieldData(row, structField), structField.getFieldObjectInspector(), objectInspectorOption));
        }
    }

    public static Object copyToStandardObject(Object o, ObjectInspector oi) {
        return ObjectInspectorUtils.copyToStandardObject(o, oi, ObjectInspectorCopyOption.DEFAULT);
    }

    public static Object copyToStandardJavaObject(Object o, ObjectInspector oi) {
        return ObjectInspectorUtils.copyToStandardObject(o, oi, ObjectInspectorCopyOption.JAVA);
    }

    public static Object copyToStandardObject(Object o, ObjectInspector oi, ObjectInspectorCopyOption objectInspectorOption) {
        if (o == null) {
            return null;
        }
        Object result = null;
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector loi = (PrimitiveObjectInspector)oi;
                switch (objectInspectorOption) {
                    case DEFAULT: {
                        if (loi.preferWritable()) {
                            result = loi.getPrimitiveWritableObject(loi.copyObject(o));
                            break;
                        }
                        result = loi.getPrimitiveJavaObject(o);
                        break;
                    }
                    case JAVA: {
                        result = loi.getPrimitiveJavaObject(o);
                        break;
                    }
                    case WRITABLE: {
                        result = loi.getPrimitiveWritableObject(loi.copyObject(o));
                    }
                }
                break;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                int length = loi.getListLength(o);
                ArrayList<Object> list = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    list.add(ObjectInspectorUtils.copyToStandardObject(loi.getListElement(o, i), loi.getListElementObjectInspector(), objectInspectorOption));
                }
                result = list;
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                Map<?, ?> omap = moi.getMap(o);
                for (Map.Entry<?, ?> entry : omap.entrySet()) {
                    map.put(ObjectInspectorUtils.copyToStandardObject(entry.getKey(), moi.getMapKeyObjectInspector(), objectInspectorOption), ObjectInspectorUtils.copyToStandardObject(entry.getValue(), moi.getMapValueObjectInspector(), objectInspectorOption));
                }
                result = map;
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                ArrayList<Object> struct = new ArrayList<Object>(fields.size());
                for (StructField structField : fields) {
                    struct.add(ObjectInspectorUtils.copyToStandardObject(soi.getStructFieldData(o, structField), structField.getFieldObjectInspector(), objectInspectorOption));
                }
                result = struct;
                break;
            }
            case UNION: {
                Object object;
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                List<ObjectInspector> objectInspectors = uoi.getObjectInspectors();
                result = object = ObjectInspectorUtils.copyToStandardObject(uoi.getField(o), objectInspectors.get(uoi.getTag(o)), objectInspectorOption);
                break;
            }
            default: {
                throw new RuntimeException("Unknown ObjectInspector category!");
            }
        }
        return result;
    }

    public static String getStandardStructTypeName(StructObjectInspector soi) {
        StringBuilder sb = new StringBuilder();
        sb.append("struct<");
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fields.get(i).getFieldName());
            sb.append(":");
            sb.append(fields.get(i).getFieldObjectInspector().getTypeName());
        }
        sb.append(">");
        return sb.toString();
    }

    public static String getStandardUnionTypeName(UnionObjectInspector uoi) {
        StringBuilder sb = new StringBuilder();
        sb.append("uniontype<");
        List<ObjectInspector> ois = uoi.getObjectInspectors();
        for (int i = 0; i < ois.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(ois.get(i).getTypeName());
        }
        sb.append(">");
        return sb.toString();
    }

    public static StructField getStandardStructFieldRef(String fieldName, List<? extends StructField> fields) {
        int i;
        fieldName = fieldName.toLowerCase();
        for (i = 0; i < fields.size(); ++i) {
            if (!fields.get(i).getFieldName().equals(fieldName)) continue;
            return fields.get(i);
        }
        try {
            i = Integer.parseInt(fieldName);
            if (i >= 0 && i < fields.size()) {
                return fields.get(i);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new RuntimeException("cannot find field " + fieldName + " from " + fields);
    }

    public static Field[] getDeclaredNonStaticFields(Class<?> c) {
        Field[] f = c.getDeclaredFields();
        ArrayList<Field> af = new ArrayList<Field>();
        for (int i = 0; i < f.length; ++i) {
            if (Modifier.isStatic(f[i].getModifiers())) continue;
            af.add(f[i]);
        }
        Field[] r = new Field[af.size()];
        for (int i = 0; i < af.size(); ++i) {
            r[i] = (Field)af.get(i);
        }
        return r;
    }

    public static String getObjectInspectorName(ObjectInspector oi) {
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                return oi.getClass().getSimpleName();
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                return oi.getClass().getSimpleName() + "<" + ObjectInspectorUtils.getObjectInspectorName(loi.getListElementObjectInspector()) + ">";
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                return oi.getClass().getSimpleName() + "<" + ObjectInspectorUtils.getObjectInspectorName(moi.getMapKeyObjectInspector()) + "," + ObjectInspectorUtils.getObjectInspectorName(moi.getMapValueObjectInspector()) + ">";
            }
            case STRUCT: {
                StringBuilder result = new StringBuilder();
                result.append(oi.getClass().getSimpleName() + "<");
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                for (int i = 0; i < fields.size(); ++i) {
                    result.append(fields.get(i).getFieldName());
                    result.append(":");
                    result.append(ObjectInspectorUtils.getObjectInspectorName(fields.get(i).getFieldObjectInspector()));
                    if (i == fields.size() - 1) {
                        result.append(">");
                        continue;
                    }
                    result.append(",");
                }
                return result.toString();
            }
            case UNION: {
                StringBuffer result = new StringBuffer();
                result.append(oi.getClass().getSimpleName() + "<");
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                List<ObjectInspector> ois = uoi.getObjectInspectors();
                for (int i = 0; i < ois.size(); ++i) {
                    if (i > 0) {
                        result.append(",");
                    }
                    result.append(ObjectInspectorUtils.getObjectInspectorName(ois.get(i)));
                }
                result.append(">");
                return result.toString();
            }
        }
        throw new RuntimeException("Unknown ObjectInspector category!");
    }

    public static int hashCode(Object o, ObjectInspector objIns) {
        if (o == null) {
            return 0;
        }
        switch (objIns.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)objIns;
                switch (poi.getPrimitiveCategory()) {
                    case VOID: {
                        return 0;
                    }
                    case BOOLEAN: {
                        return ((BooleanObjectInspector)poi).get(o) ? 1 : 0;
                    }
                    case BYTE: {
                        return ((ByteObjectInspector)poi).get(o);
                    }
                    case SHORT: {
                        return ((ShortObjectInspector)poi).get(o);
                    }
                    case INT: {
                        return ((IntObjectInspector)poi).get(o);
                    }
                    case LONG: {
                        long a = ((LongObjectInspector)poi).get(o);
                        return (int)(a >>> 32 ^ a);
                    }
                    case FLOAT: {
                        return Float.floatToIntBits(((FloatObjectInspector)poi).get(o));
                    }
                    case DOUBLE: {
                        long a = Double.doubleToLongBits(((DoubleObjectInspector)poi).get(o));
                        return (int)(a >>> 32 ^ a);
                    }
                    case STRING: {
                        Text t = ((StringObjectInspector)poi).getPrimitiveWritableObject(o);
                        int r = 0;
                        for (int i = 0; i < t.getLength(); ++i) {
                            r = r * 31 + t.getBytes()[i];
                        }
                        return r;
                    }
                    case VARCHAR: {
                        return ((HiveVarcharObjectInspector)poi).getPrimitiveWritableObject(o).hashCode();
                    }
                    case BINARY: {
                        return ((BinaryObjectInspector)poi).getPrimitiveWritableObject(o).hashCode();
                    }
                    case DATE: {
                        return ((DateObjectInspector)poi).getPrimitiveWritableObject(o).hashCode();
                    }
                    case TIMESTAMP: {
                        TimestampWritable t = ((TimestampObjectInspector)poi).getPrimitiveWritableObject(o);
                        return t.hashCode();
                    }
                    case DECIMAL: {
                        return ((HiveDecimalObjectInspector)poi).getPrimitiveWritableObject(o).hashCode();
                    }
                }
                throw new RuntimeException("Unknown type: " + (Object)((Object)poi.getPrimitiveCategory()));
            }
            case LIST: {
                int r = 0;
                ListObjectInspector listOI = (ListObjectInspector)objIns;
                ObjectInspector elemOI = listOI.getListElementObjectInspector();
                for (int ii = 0; ii < listOI.getListLength(o); ++ii) {
                    r = 31 * r + ObjectInspectorUtils.hashCode(listOI.getListElement(o, ii), elemOI);
                }
                return r;
            }
            case MAP: {
                int r = 0;
                MapObjectInspector mapOI = (MapObjectInspector)objIns;
                ObjectInspector keyOI = mapOI.getMapKeyObjectInspector();
                ObjectInspector valueOI = mapOI.getMapValueObjectInspector();
                Map<?, ?> map = mapOI.getMap(o);
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    r += ObjectInspectorUtils.hashCode(entry.getKey(), keyOI) ^ ObjectInspectorUtils.hashCode(entry.getValue(), valueOI);
                }
                return r;
            }
            case STRUCT: {
                int r = 0;
                StructObjectInspector structOI = (StructObjectInspector)objIns;
                List<? extends StructField> fields = structOI.getAllStructFieldRefs();
                for (StructField structField : fields) {
                    r = 31 * r + ObjectInspectorUtils.hashCode(structOI.getStructFieldData(o, structField), structField.getFieldObjectInspector());
                }
                return r;
            }
            case UNION: {
                UnionObjectInspector uOI = (UnionObjectInspector)objIns;
                byte by = uOI.getTag(o);
                return ObjectInspectorUtils.hashCode(uOI.getField(o), uOI.getObjectInspectors().get(by));
            }
        }
        throw new RuntimeException("Unknown type: " + objIns.getTypeName());
    }

    public static int compare(Object[] o1, ObjectInspector[] oi1, Object[] o2, ObjectInspector[] oi2) {
        assert (o1.length == oi1.length);
        assert (o2.length == oi2.length);
        assert (o1.length == o2.length);
        for (int i = 0; i < o1.length; ++i) {
            int r = ObjectInspectorUtils.compare(o1[i], oi1[i], o2[i], oi2[i]);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    public static boolean compareSupported(ObjectInspector oi) {
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                return true;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                return ObjectInspectorUtils.compareSupported(loi.getListElementObjectInspector());
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                for (int f = 0; f < fields.size(); ++f) {
                    if (ObjectInspectorUtils.compareSupported(fields.get(f).getFieldObjectInspector())) continue;
                    return false;
                }
                return true;
            }
            case MAP: {
                return false;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                for (ObjectInspector eoi : uoi.getObjectInspectors()) {
                    if (ObjectInspectorUtils.compareSupported(eoi)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static int compare(Object o1, ObjectInspector oi1, Object o2, ObjectInspector oi2) {
        return ObjectInspectorUtils.compare(o1, oi1, o2, oi2, new FullMapEqualComparer());
    }

    public static int compare(Object o1, ObjectInspector oi1, Object o2, ObjectInspector oi2, MapEqualComparer mapEqualComparer) {
        if (oi1.getCategory() != oi2.getCategory()) {
            return oi1.getCategory().compareTo(oi2.getCategory());
        }
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        switch (oi1.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi1 = (PrimitiveObjectInspector)oi1;
                PrimitiveObjectInspector poi2 = (PrimitiveObjectInspector)oi2;
                if (poi1.getPrimitiveCategory() != poi2.getPrimitiveCategory()) {
                    return poi1.getPrimitiveCategory().compareTo(poi2.getPrimitiveCategory());
                }
                switch (poi1.getPrimitiveCategory()) {
                    case VOID: {
                        return 0;
                    }
                    case BOOLEAN: {
                        int v1 = ((BooleanObjectInspector)poi1).get(o1) ? 1 : 0;
                        int v2 = ((BooleanObjectInspector)poi2).get(o2) ? 1 : 0;
                        return v1 - v2;
                    }
                    case BYTE: {
                        byte v1 = ((ByteObjectInspector)poi1).get(o1);
                        byte v2 = ((ByteObjectInspector)poi2).get(o2);
                        return v1 - v2;
                    }
                    case SHORT: {
                        short v1 = ((ShortObjectInspector)poi1).get(o1);
                        short v2 = ((ShortObjectInspector)poi2).get(o2);
                        return v1 - v2;
                    }
                    case INT: {
                        int v1 = ((IntObjectInspector)poi1).get(o1);
                        int v2 = ((IntObjectInspector)poi2).get(o2);
                        return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
                    }
                    case LONG: {
                        long v1 = ((LongObjectInspector)poi1).get(o1);
                        long v2 = ((LongObjectInspector)poi2).get(o2);
                        return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
                    }
                    case FLOAT: {
                        float v1 = ((FloatObjectInspector)poi1).get(o1);
                        float v2 = ((FloatObjectInspector)poi2).get(o2);
                        return Float.compare(v1, v2);
                    }
                    case DOUBLE: {
                        double v1 = ((DoubleObjectInspector)poi1).get(o1);
                        double v2 = ((DoubleObjectInspector)poi2).get(o2);
                        return Double.compare(v1, v2);
                    }
                    case STRING: {
                        if (poi1.preferWritable() || poi2.preferWritable()) {
                            Text t1 = (Text)poi1.getPrimitiveWritableObject(o1);
                            Text t2 = (Text)poi2.getPrimitiveWritableObject(o2);
                            return t1 == null ? (t2 == null ? 0 : -1) : (t2 == null ? 1 : ShimLoader.getHadoopShims().compareText(t1, t2));
                        }
                        String s1 = (String)poi1.getPrimitiveJavaObject(o1);
                        String s2 = (String)poi2.getPrimitiveJavaObject(o2);
                        return s1 == null ? (s2 == null ? 0 : -1) : (s2 == null ? 1 : s1.compareTo(s2));
                    }
                    case VARCHAR: {
                        HiveVarcharWritable t1 = ((HiveVarcharObjectInspector)poi1).getPrimitiveWritableObject(o1);
                        HiveVarcharWritable t2 = ((HiveVarcharObjectInspector)poi2).getPrimitiveWritableObject(o2);
                        return t1.compareTo(t2);
                    }
                    case BINARY: {
                        BytesWritable bw1 = ((BinaryObjectInspector)poi1).getPrimitiveWritableObject(o1);
                        BytesWritable bw2 = ((BinaryObjectInspector)poi2).getPrimitiveWritableObject(o2);
                        return bw1.compareTo((BinaryComparable)bw2);
                    }
                    case DATE: {
                        DateWritable d1 = ((DateObjectInspector)poi1).getPrimitiveWritableObject(o1);
                        DateWritable d2 = ((DateObjectInspector)poi2).getPrimitiveWritableObject(o2);
                        return d1.compareTo(d2);
                    }
                    case TIMESTAMP: {
                        TimestampWritable t1 = ((TimestampObjectInspector)poi1).getPrimitiveWritableObject(o1);
                        TimestampWritable t2 = ((TimestampObjectInspector)poi2).getPrimitiveWritableObject(o2);
                        return t1.compareTo(t2);
                    }
                    case DECIMAL: {
                        HiveDecimalWritable t1 = ((HiveDecimalObjectInspector)poi1).getPrimitiveWritableObject(o1);
                        HiveDecimalWritable t2 = ((HiveDecimalObjectInspector)poi2).getPrimitiveWritableObject(o2);
                        return t1.compareTo(t2);
                    }
                }
                throw new RuntimeException("Unknown type: " + (Object)((Object)poi1.getPrimitiveCategory()));
            }
            case STRUCT: {
                StructObjectInspector soi1 = (StructObjectInspector)oi1;
                StructObjectInspector soi2 = (StructObjectInspector)oi2;
                List<? extends StructField> fields1 = soi1.getAllStructFieldRefs();
                List<? extends StructField> fields2 = soi2.getAllStructFieldRefs();
                int minimum = Math.min(fields1.size(), fields2.size());
                for (int i = 0; i < minimum; ++i) {
                    int r = ObjectInspectorUtils.compare(soi1.getStructFieldData(o1, fields1.get(i)), fields1.get(i).getFieldObjectInspector(), soi2.getStructFieldData(o2, fields2.get(i)), fields2.get(i).getFieldObjectInspector(), mapEqualComparer);
                    if (r == 0) continue;
                    return r;
                }
                return fields1.size() - fields2.size();
            }
            case LIST: {
                ListObjectInspector loi1 = (ListObjectInspector)oi1;
                ListObjectInspector loi2 = (ListObjectInspector)oi2;
                int minimum = Math.min(loi1.getListLength(o1), loi2.getListLength(o2));
                for (int i = 0; i < minimum; ++i) {
                    int r = ObjectInspectorUtils.compare(loi1.getListElement(o1, i), loi1.getListElementObjectInspector(), loi2.getListElement(o2, i), loi2.getListElementObjectInspector(), mapEqualComparer);
                    if (r == 0) continue;
                    return r;
                }
                return loi1.getListLength(o1) - loi2.getListLength(o2);
            }
            case MAP: {
                if (mapEqualComparer == null) {
                    throw new RuntimeException("Compare on map type not supported!");
                }
                return mapEqualComparer.compare(o1, (MapObjectInspector)oi1, o2, (MapObjectInspector)oi2);
            }
            case UNION: {
                UnionObjectInspector uoi1 = (UnionObjectInspector)oi1;
                UnionObjectInspector uoi2 = (UnionObjectInspector)oi2;
                byte tag1 = uoi1.getTag(o1);
                byte tag2 = uoi2.getTag(o2);
                if (tag1 != tag2) {
                    return tag1 - tag2;
                }
                return ObjectInspectorUtils.compare(uoi1.getField(o1), uoi1.getObjectInspectors().get(tag1), uoi2.getField(o2), uoi2.getObjectInspectors().get(tag2), mapEqualComparer);
            }
        }
        throw new RuntimeException("Compare on unknown type: " + (Object)((Object)oi1.getCategory()));
    }

    public static String getFieldNames(StructObjectInspector soi) {
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fields.get(i).getFieldName());
        }
        return sb.toString();
    }

    public static String getFieldTypes(StructObjectInspector soi) {
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                sb.append(":");
            }
            sb.append(TypeInfoUtils.getTypeInfoFromObjectInspector(fields.get(i).getFieldObjectInspector()).getTypeName());
        }
        return sb.toString();
    }

    public static String getTypeNameFromJavaClass(Type t) {
        try {
            ObjectInspector oi = ObjectInspectorFactory.getReflectionObjectInspector(t, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            return oi.getTypeName();
        }
        catch (Throwable e) {
            LOG.info((Object)StringUtils.stringifyException((Throwable)e));
            return "unknown";
        }
    }

    public static boolean compareTypes(ObjectInspector o1, ObjectInspector o2) {
        ObjectInspector.Category c2;
        ObjectInspector.Category c1 = o1.getCategory();
        if (!c1.equals((Object)(c2 = o2.getCategory()))) {
            return false;
        }
        if (c1.equals((Object)ObjectInspector.Category.PRIMITIVE)) {
            return o1.getTypeName().equals(o2.getTypeName());
        }
        if (c1.equals((Object)ObjectInspector.Category.LIST)) {
            ObjectInspector child1 = ((ListObjectInspector)o1).getListElementObjectInspector();
            ObjectInspector child2 = ((ListObjectInspector)o2).getListElementObjectInspector();
            return ObjectInspectorUtils.compareTypes(child1, child2);
        }
        if (c1.equals((Object)ObjectInspector.Category.MAP)) {
            ObjectInspector childVal2;
            ObjectInspector childVal1;
            ObjectInspector childKey2;
            MapObjectInspector mapOI1 = (MapObjectInspector)o1;
            MapObjectInspector mapOI2 = (MapObjectInspector)o2;
            ObjectInspector childKey1 = mapOI1.getMapKeyObjectInspector();
            return ObjectInspectorUtils.compareTypes(childKey1, childKey2 = mapOI2.getMapKeyObjectInspector()) && ObjectInspectorUtils.compareTypes(childVal1 = mapOI1.getMapValueObjectInspector(), childVal2 = mapOI2.getMapValueObjectInspector());
        }
        if (c1.equals((Object)ObjectInspector.Category.STRUCT)) {
            StructObjectInspector structOI1 = (StructObjectInspector)o1;
            StructObjectInspector structOI2 = (StructObjectInspector)o2;
            List<? extends StructField> childFieldsList1 = structOI1.getAllStructFieldRefs();
            List<? extends StructField> childFieldsList2 = structOI2.getAllStructFieldRefs();
            if (childFieldsList1 == null && childFieldsList2 == null) {
                return true;
            }
            if (childFieldsList1.size() != childFieldsList2.size()) {
                return false;
            }
            Iterator<? extends StructField> it1 = childFieldsList1.iterator();
            Iterator<? extends StructField> it2 = childFieldsList2.iterator();
            while (it1.hasNext()) {
                StructField field1 = it1.next();
                StructField field2 = it2.next();
                if (ObjectInspectorUtils.compareTypes(field1.getFieldObjectInspector(), field2.getFieldObjectInspector())) continue;
                return false;
            }
            return true;
        }
        if (c1.equals((Object)ObjectInspector.Category.UNION)) {
            UnionObjectInspector uoi1 = (UnionObjectInspector)o1;
            UnionObjectInspector uoi2 = (UnionObjectInspector)o2;
            List<ObjectInspector> ois1 = uoi1.getObjectInspectors();
            List<ObjectInspector> ois2 = uoi2.getObjectInspectors();
            if (ois1 == null && ois2 == null) {
                return true;
            }
            if (ois1 == null || ois2 == null) {
                return false;
            }
            if (ois1.size() != ois2.size()) {
                return false;
            }
            Iterator<ObjectInspector> it1 = ois1.iterator();
            Iterator<ObjectInspector> it2 = ois2.iterator();
            while (it1.hasNext()) {
                if (ObjectInspectorUtils.compareTypes(it1.next(), it2.next())) continue;
                return false;
            }
            return true;
        }
        throw new RuntimeException("Unknown category encountered: " + (Object)((Object)c1));
    }

    public static ConstantObjectInspector getConstantObjectInspector(ObjectInspector oi, Object value) {
        ObjectInspector writableOI = ObjectInspectorUtils.getStandardObjectInspector(oi, ObjectInspectorCopyOption.WRITABLE);
        Object writableValue = ObjectInspectorConverters.getConverter(oi, writableOI).convert(value);
        switch (writableOI.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                return PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector(poi, writableValue);
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                return ObjectInspectorFactory.getStandardConstantListObjectInspector(ObjectInspectorUtils.getStandardObjectInspector(loi.getListElementObjectInspector(), ObjectInspectorCopyOption.WRITABLE), (List)writableValue);
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                return ObjectInspectorFactory.getStandardConstantMapObjectInspector(ObjectInspectorUtils.getStandardObjectInspector(moi.getMapKeyObjectInspector(), ObjectInspectorCopyOption.WRITABLE), ObjectInspectorUtils.getStandardObjectInspector(moi.getMapValueObjectInspector(), ObjectInspectorCopyOption.WRITABLE), (Map)writableValue);
            }
        }
        throw new IllegalArgumentException((Object)((Object)writableOI.getCategory()) + " not yet supported for constant OI");
    }

    public static Object getWritableConstantValue(ObjectInspector oi) {
        return ((ConstantObjectInspector)oi).getWritableConstantValue();
    }

    public static boolean supportsConstantObjectInspector(ObjectInspector oi) {
        switch (oi.getCategory()) {
            case PRIMITIVE: 
            case LIST: 
            case MAP: {
                return true;
            }
        }
        return false;
    }

    public static boolean isConstantObjectInspector(ObjectInspector oi) {
        return oi instanceof ConstantObjectInspector;
    }

    private ObjectInspectorUtils() {
    }

    public static enum ObjectInspectorCopyOption {
        DEFAULT,
        JAVA,
        WRITABLE;

    }
}

