/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class ByteWritable
implements WritableComparable {
    private byte value;

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.value);
    }

    public void readFields(DataInput in) throws IOException {
        this.value = in.readByte();
    }

    public ByteWritable(byte b) {
        this.value = b;
    }

    public ByteWritable() {
        this.value = 0;
    }

    public void set(byte value) {
        this.value = value;
    }

    public byte get() {
        return this.value;
    }

    public int compareTo(Object o) {
        byte thisValue = this.value;
        byte thatValue = ((ByteWritable)o).value;
        return thisValue - thatValue;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != ByteWritable.class) {
            return false;
        }
        return this.get() == ((ByteWritable)o).get();
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    static {
        WritableComparator.define(ByteWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(ByteWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            byte a1 = b1[s1];
            byte a2 = b2[s2];
            return a1 - a2;
        }
    }
}

