/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;

public class CapacityHeadroomProvider {
    LeafQueue.User user;
    LeafQueue queue;
    FiCaSchedulerApp application;
    Resource required;
    LeafQueue.QueueHeadroomInfo queueHeadroomInfo;

    public CapacityHeadroomProvider(LeafQueue.User user, LeafQueue queue, FiCaSchedulerApp application, Resource required, LeafQueue.QueueHeadroomInfo queueHeadroomInfo) {
        this.user = user;
        this.queue = queue;
        this.application = application;
        this.required = required;
        this.queueHeadroomInfo = queueHeadroomInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getHeadroom() {
        Resource clusterResource;
        Resource queueMaxCap;
        LeafQueue.QueueHeadroomInfo queueHeadroomInfo = this.queueHeadroomInfo;
        synchronized (queueHeadroomInfo) {
            queueMaxCap = this.queueHeadroomInfo.getQueueMaxCap();
            clusterResource = this.queueHeadroomInfo.getClusterResource();
        }
        Resource headroom = this.queue.getHeadroom(this.user, queueMaxCap, clusterResource, this.application, this.required);
        if (headroom.getMemory() < 0) {
            headroom.setMemory(0);
        }
        return headroom;
    }
}

