/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.factory.providers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "YARN"})
@InterfaceStability.Unstable
public class RecordFactoryProvider {
    private static Configuration defaultConf = new Configuration();

    private RecordFactoryProvider() {
    }

    public static RecordFactory getRecordFactory(Configuration conf) {
        if (conf == null) {
            conf = defaultConf;
        }
        String recordFactoryClassName = conf.get("yarn.ipc.record.factory.class", "org.apache.hadoop.yarn.factories.impl.pb.RecordFactoryPBImpl");
        return (RecordFactory)RecordFactoryProvider.getFactoryClassInstance(recordFactoryClassName);
    }

    private static Object getFactoryClassInstance(String factoryClassName) {
        try {
            Class<?> clazz = Class.forName(factoryClassName);
            Method method = clazz.getMethod("get", null);
            method.setAccessible(true);
            return method.invoke(null, null);
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new YarnRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new YarnRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new YarnRuntimeException(e);
        }
    }
}

