/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.util.SampleStat;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MutableRatesWithAggregation
extends MutableMetric {
    static final Log LOG = LogFactory.getLog(MutableRatesWithAggregation.class);
    private final Map<String, MutableRate> globalMetrics = new HashMap<String, MutableRate>();
    private final Set<Class<?>> protocolCache = Sets.newHashSet();
    private final ConcurrentLinkedDeque<WeakReference<ConcurrentMap<String, ThreadSafeSampleStat>>> weakReferenceQueue = new ConcurrentLinkedDeque();
    private final ThreadLocal<ConcurrentMap<String, ThreadSafeSampleStat>> threadLocalMetricsMap = new ThreadLocal();

    public void init(Class<?> protocol) {
        if (this.protocolCache.contains(protocol)) {
            return;
        }
        this.protocolCache.add(protocol);
        for (Method method : protocol.getDeclaredMethods()) {
            String name = method.getName();
            LOG.debug((Object)name);
            this.addMetricIfNotExists(name);
        }
    }

    public void add(String name, long elapsed) {
        ThreadSafeSampleStat stat;
        ConcurrentMap<String, ThreadSafeSampleStat> localStats = this.threadLocalMetricsMap.get();
        if (localStats == null) {
            localStats = new ConcurrentHashMap<String, ThreadSafeSampleStat>();
            this.threadLocalMetricsMap.set(localStats);
            this.weakReferenceQueue.add(new WeakReference<ConcurrentMap<String, ThreadSafeSampleStat>>(localStats));
        }
        if ((stat = (ThreadSafeSampleStat)localStats.get(name)) == null) {
            stat = new ThreadSafeSampleStat();
            localStats.put(name, stat);
        }
        stat.add(elapsed);
    }

    @Override
    public synchronized void snapshot(MetricsRecordBuilder rb, boolean all) {
        Iterator<WeakReference<ConcurrentMap<String, ThreadSafeSampleStat>>> iter = this.weakReferenceQueue.iterator();
        while (iter.hasNext()) {
            ConcurrentMap map = (ConcurrentMap)iter.next().get();
            if (map == null) {
                iter.remove();
                continue;
            }
            for (Map.Entry entry : map.entrySet()) {
                String name = (String)entry.getKey();
                MutableRate globalMetric = this.addMetricIfNotExists(name);
                ((ThreadSafeSampleStat)entry.getValue()).snapshotInto(globalMetric);
            }
        }
        for (MutableRate globalMetric : this.globalMetrics.values()) {
            globalMetric.snapshot(rb, all);
        }
    }

    private synchronized MutableRate addMetricIfNotExists(String name) {
        MutableRate metric = this.globalMetrics.get(name);
        if (metric == null) {
            metric = new MutableRate(name, name, false);
            this.globalMetrics.put(name, metric);
        }
        return metric;
    }

    private static class ThreadSafeSampleStat {
        private SampleStat stat = new SampleStat();

        private ThreadSafeSampleStat() {
        }

        synchronized void add(double x) {
            this.stat.add(x);
        }

        synchronized void snapshotInto(MutableRate metric) {
            if (this.stat.numSamples() > 0L) {
                metric.add(this.stat.numSamples(), Math.round(this.stat.total()));
                this.stat.reset();
            }
        }
    }
}

