/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Collections;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.inference.TypeStrategiesTestBase;
import org.apache.flink.table.types.inference.strategies.SpecificTypeStrategies;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.StructuredType;

class GetTypeStrategyTest
extends TypeStrategiesTestBase {
    GetTypeStrategyTest() {
    }

    @Override
    protected Stream<TypeStrategiesTestBase.TestSpec> testData() {
        return Stream.of(TypeStrategiesTestBase.TestSpec.forStrategy("Access field of a row nullable type by name", SpecificTypeStrategies.GET).inputTypes(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (DataType)DataTypes.STRING().notNull()).calledWithLiteralAt(1, "f0").expectDataType((DataType)DataTypes.BIGINT().nullable()), TypeStrategiesTestBase.TestSpec.forStrategy("Access field of a row not null type by name", SpecificTypeStrategies.GET).inputTypes((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).notNull(), (DataType)DataTypes.STRING().notNull()).calledWithLiteralAt(1, "f0").expectDataType((DataType)DataTypes.BIGINT().notNull()), TypeStrategiesTestBase.TestSpec.forStrategy("Access field of a structured nullable type by name", SpecificTypeStrategies.GET).inputTypes(new FieldsDataType((LogicalType)StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"type")).attributes(Collections.singletonList(new StructuredType.StructuredAttribute("f0", (LogicalType)new BigIntType(false)))).build(), Collections.singletonList(DataTypes.BIGINT().notNull())).nullable(), (DataType)DataTypes.STRING().notNull()).calledWithLiteralAt(1, "f0").expectDataType((DataType)DataTypes.BIGINT().nullable()), TypeStrategiesTestBase.TestSpec.forStrategy("Access field of a structured not null type by name", SpecificTypeStrategies.GET).inputTypes(new FieldsDataType((LogicalType)StructuredType.newBuilder((ObjectIdentifier)ObjectIdentifier.of((String)"cat", (String)"db", (String)"type")).attributes(Collections.singletonList(new StructuredType.StructuredAttribute("f0", (LogicalType)new BigIntType(false)))).build(), Collections.singletonList(DataTypes.BIGINT().notNull())).notNull(), (DataType)DataTypes.STRING().notNull()).calledWithLiteralAt(1, "f0").expectDataType((DataType)DataTypes.BIGINT().notNull()), TypeStrategiesTestBase.TestSpec.forStrategy("Access field of a row nullable type by index", SpecificTypeStrategies.GET).inputTypes(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (DataType)DataTypes.INT().notNull()).calledWithLiteralAt(1, 0).expectDataType((DataType)DataTypes.BIGINT().nullable()), TypeStrategiesTestBase.TestSpec.forStrategy("Access field of a row not null type by index", SpecificTypeStrategies.GET).inputTypes((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).notNull(), (DataType)DataTypes.INT().notNull()).calledWithLiteralAt(1, 0).expectDataType((DataType)DataTypes.BIGINT().notNull()), TypeStrategiesTestBase.TestSpec.forStrategy("Fields can be accessed only with a literal (name)", SpecificTypeStrategies.GET).inputTypes((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).notNull(), (DataType)DataTypes.STRING().notNull()).expectErrorMessage("Could not infer an output type for the given arguments."), TypeStrategiesTestBase.TestSpec.forStrategy("Fields can be accessed only with a literal (index)", SpecificTypeStrategies.GET).inputTypes((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f0", (DataType)((DataType)DataTypes.BIGINT().notNull()))}).notNull(), (DataType)DataTypes.INT().notNull()).expectErrorMessage("Could not infer an output type for the given arguments."));
    }
}

