/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.columnar.vector;

import java.nio.charset.StandardCharsets;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.columnar.vector.Dictionary;
import org.apache.flink.table.data.columnar.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapBooleanVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapByteVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapBytesVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapDoubleVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapFloatVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapIntVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapLongVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapShortVector;
import org.apache.flink.table.data.columnar.vector.heap.HeapTimestampVector;
import org.apache.flink.table.data.columnar.vector.writable.WritableColumnVector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ColumnVectorTest {
    private static final int SIZE = 10;

    ColumnVectorTest() {
    }

    @Test
    void testNulls() {
        int i;
        HeapBooleanVector vector = new HeapBooleanVector(10);
        for (i = 0; i < 10; ++i) {
            if (i % 2 != 0) continue;
            vector.setNullAt(i);
        }
        for (i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                Assertions.assertThat((boolean)vector.isNullAt(i)).isTrue();
                continue;
            }
            Assertions.assertThat((boolean)vector.isNullAt(i)).isFalse();
        }
        vector.fillWithNulls();
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((boolean)vector.isNullAt(i)).isTrue();
        }
        vector.reset();
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((boolean)vector.isNullAt(i)).isFalse();
        }
        vector.setNulls(0, 5);
        for (i = 0; i < 5; ++i) {
            Assertions.assertThat((boolean)vector.isNullAt(i)).isTrue();
        }
    }

    @Test
    void testBoolean() {
        int i;
        HeapBooleanVector vector = new HeapBooleanVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setBoolean(i, i % 2 == 0);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((boolean)vector.getBoolean(i)).isEqualTo(i % 2 == 0);
        }
        vector.fill(true);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((boolean)vector.getBoolean(i)).isTrue();
        }
    }

    @Test
    void testByte() {
        int i;
        HeapByteVector vector = new HeapByteVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setByte(i, (byte)i);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((byte)vector.getByte(i)).isEqualTo((byte)i);
        }
        vector.fill((byte)22);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((byte)vector.getByte(i)).isEqualTo((byte)22);
        }
        vector.setDictionary((Dictionary)new TestDictionary(IntStream.range(0, 10).boxed().toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((byte)vector.getByte(i)).isEqualTo((byte)i);
        }
    }

    @Test
    void testShort() {
        int i;
        HeapShortVector vector = new HeapShortVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setShort(i, (short)i);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((short)vector.getShort(i)).isEqualTo((short)i);
        }
        vector.fill((short)22);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((short)vector.getShort(i)).isEqualTo((short)22);
        }
        vector.setDictionary((Dictionary)new TestDictionary(IntStream.range(0, 10).boxed().toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((short)vector.getShort(i)).isEqualTo((short)i);
        }
    }

    @Test
    void testInt() {
        int i;
        HeapIntVector vector = new HeapIntVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setInt(i, i);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((int)vector.getInt(i)).isEqualTo(i);
        }
        vector.fill(22);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((int)vector.getInt(i)).isEqualTo(22);
        }
        vector = new HeapIntVector(10);
        vector.setInts(0, 10, 22);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((int)vector.getInt(i)).isEqualTo(22);
        }
        vector.setDictionary((Dictionary)new TestDictionary(IntStream.range(0, 10).boxed().toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((int)vector.getInt(i)).isEqualTo(i);
        }
        int[] ints = IntStream.range(0, 10).toArray();
        byte[] binary = new byte[80];
        AbstractHeapVector.UNSAFE.copyMemory(ints, AbstractHeapVector.INT_ARRAY_OFFSET, binary, AbstractHeapVector.BYTE_ARRAY_OFFSET, binary.length);
        vector = new HeapIntVector(10);
        vector.setIntsFromBinary(0, 10, binary, 0);
        for (int i2 = 0; i2 < 10; ++i2) {
            Assertions.assertThat((int)vector.getInt(i2)).isEqualTo(i2);
        }
    }

    @Test
    void testLong() {
        int i;
        HeapLongVector vector = new HeapLongVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setLong(i, (long)i);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((long)vector.getLong(i)).isEqualTo((long)i);
        }
        vector.fill(22L);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((long)vector.getLong(i)).isEqualTo(22L);
        }
        vector.setDictionary((Dictionary)new TestDictionary(LongStream.range(0L, 10L).boxed().toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((long)vector.getLong(i)).isEqualTo((long)i);
        }
        long[] longs = LongStream.range(0L, 10L).toArray();
        byte[] binary = new byte[80];
        AbstractHeapVector.UNSAFE.copyMemory(longs, AbstractHeapVector.LONG_ARRAY_OFFSET, binary, AbstractHeapVector.BYTE_ARRAY_OFFSET, binary.length);
        vector = new HeapLongVector(10);
        vector.setLongsFromBinary(0, 10, binary, 0);
        for (int i2 = 0; i2 < 10; ++i2) {
            Assertions.assertThat((long)vector.getLong(i2)).isEqualTo((long)i2);
        }
    }

    @Test
    void testFloat() {
        int i;
        HeapFloatVector vector = new HeapFloatVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setFloat(i, (float)i);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((float)vector.getFloat(i)).isEqualTo((float)i);
        }
        vector.fill(22.0f);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((float)vector.getFloat(i)).isEqualTo(22.0f);
        }
        vector.setDictionary((Dictionary)new TestDictionary(LongStream.range(0L, 10L).boxed().map(Number::floatValue).toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((float)vector.getFloat(i)).isEqualTo((float)i);
        }
        float[] floats = new float[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            floats[i2] = i2;
        }
        byte[] binary = new byte[40];
        AbstractHeapVector.UNSAFE.copyMemory(floats, AbstractHeapVector.FLOAT_ARRAY_OFFSET, binary, AbstractHeapVector.BYTE_ARRAY_OFFSET, binary.length);
        vector = new HeapFloatVector(10);
        vector.setFloatsFromBinary(0, 10, binary, 0);
        for (int i3 = 0; i3 < 10; ++i3) {
            Assertions.assertThat((float)vector.getFloat(i3)).isEqualTo((float)i3);
        }
    }

    @Test
    void testDouble() {
        int i;
        HeapDoubleVector vector = new HeapDoubleVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setDouble(i, (double)i);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((double)vector.getDouble(i)).isEqualTo((double)i);
        }
        vector.fill(22.0);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((double)vector.getDouble(i)).isEqualTo(22.0);
        }
        vector.setDictionary((Dictionary)new TestDictionary(LongStream.range(0L, 10L).boxed().map(Number::doubleValue).toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((double)vector.getDouble(i)).isEqualTo((double)i);
        }
        double[] doubles = LongStream.range(0L, 10L).boxed().mapToDouble(Number::doubleValue).toArray();
        byte[] binary = new byte[80];
        AbstractHeapVector.UNSAFE.copyMemory(doubles, AbstractHeapVector.DOUBLE_ARRAY_OFFSET, binary, AbstractHeapVector.BYTE_ARRAY_OFFSET, binary.length);
        vector = new HeapDoubleVector(10);
        vector.setDoublesFromBinary(0, 10, binary, 0);
        for (int i2 = 0; i2 < 10; ++i2) {
            Assertions.assertThat((double)vector.getDouble(i2)).isEqualTo((double)i2);
        }
    }

    private byte[] produceBytes(int i) {
        return (i + "").getBytes(StandardCharsets.UTF_8);
    }

    @Test
    void testBytes() {
        byte[] bytes;
        int i;
        HeapBytesVector vector = new HeapBytesVector(10);
        for (i = 0; i < 10; ++i) {
            bytes = this.produceBytes(i);
            vector.appendBytes(i, bytes, 0, bytes.length);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((byte[])vector.getBytes(i).getBytes()).isEqualTo((Object)this.produceBytes(i));
        }
        vector.reset();
        for (i = 0; i < 10; ++i) {
            bytes = this.produceBytes(i);
            vector.appendBytes(i, bytes, 0, bytes.length);
        }
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((byte[])vector.getBytes(i).getBytes()).isEqualTo((Object)this.produceBytes(i));
        }
        vector.fill(this.produceBytes(22));
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((byte[])vector.getBytes(i).getBytes()).isEqualTo((Object)this.produceBytes(22));
        }
        vector.setDictionary((Dictionary)new TestDictionary(IntStream.range(0, 10).mapToObj(this::produceBytes).toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assertions.assertThat((byte[])vector.getBytes(i).getBytes()).isEqualTo((Object)this.produceBytes(i));
        }
    }

    @Test
    void testTimestamp() {
        int i2;
        HeapTimestampVector vector = new HeapTimestampVector(10);
        for (i2 = 0; i2 < 10; ++i2) {
            vector.setTimestamp(i2, TimestampData.fromEpochMillis((long)i2, (int)i2));
        }
        for (i2 = 0; i2 < 10; ++i2) {
            Assertions.assertThat((Comparable)vector.getTimestamp(i2, 9)).isEqualTo((Object)TimestampData.fromEpochMillis((long)i2, (int)i2));
        }
        vector.fill(TimestampData.fromEpochMillis((long)22L, (int)22));
        for (i2 = 0; i2 < 10; ++i2) {
            Assertions.assertThat((Comparable)vector.getTimestamp(i2, 9)).isEqualTo((Object)TimestampData.fromEpochMillis((long)22L, (int)22));
        }
        vector.setDictionary((Dictionary)new TestDictionary(IntStream.range(0, 10).mapToObj(i -> TimestampData.fromEpochMillis((long)i, (int)i)).toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i2 = 0; i2 < 10; ++i2) {
            Assertions.assertThat((Comparable)vector.getTimestamp(i2, 9)).isEqualTo((Object)TimestampData.fromEpochMillis((long)i2, (int)i2));
        }
    }

    @Test
    void testReserveDictIds() {
        HeapIntVector vector = new HeapIntVector(10);
        Assertions.assertThat((int)vector.reserveDictionaryIds((int)2).vector.length).isGreaterThanOrEqualTo(2);
        Assertions.assertThat((int)vector.reserveDictionaryIds((int)5).vector.length).isGreaterThanOrEqualTo(5);
        Assertions.assertThat((int)vector.reserveDictionaryIds((int)2).vector.length).isGreaterThanOrEqualTo(2);
    }

    private void setRangeDictIds(WritableColumnVector vector) {
        vector.reserveDictionaryIds(10).setInts(0, 10, IntStream.range(0, 10).toArray(), 0);
    }

    static final class TestDictionary
    implements Dictionary {
        private Object[] intDictionary;

        TestDictionary(Object[] dictionary) {
            this.intDictionary = dictionary;
        }

        public int decodeToInt(int id) {
            return (Integer)this.intDictionary[id];
        }

        public long decodeToLong(int id) {
            return (Long)this.intDictionary[id];
        }

        public float decodeToFloat(int id) {
            return ((Float)this.intDictionary[id]).floatValue();
        }

        public double decodeToDouble(int id) {
            return (Double)this.intDictionary[id];
        }

        public byte[] decodeToBinary(int id) {
            return (byte[])this.intDictionary[id];
        }

        public TimestampData decodeToTimestamp(int id) {
            return (TimestampData)this.intDictionary[id];
        }
    }
}

