/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source;

import java.util.Objects;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.CompactPartitions;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.connector.source.TestManagedSource;
import org.apache.flink.table.factories.DynamicTableFactory;

public class TestManagedTableSource
implements ScanTableSource {
    private final DynamicTableFactory.Context context;
    private final CompactPartitions partitions;
    private final ChangelogMode changelogMode;

    public TestManagedTableSource(DynamicTableFactory.Context context, CompactPartitions partitions, ChangelogMode changelogMode) {
        this.context = context;
        this.partitions = partitions;
        this.changelogMode = changelogMode;
    }

    public ChangelogMode getChangelogMode() {
        return this.changelogMode;
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        return SourceProvider.of((Source)new TestManagedSource(this.partitions));
    }

    public DynamicTableSource copy() {
        return new TestManagedTableSource(this.context, this.partitions, this.changelogMode);
    }

    public String asSummaryString() {
        return "TestManagedTableSource";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestManagedTableSource)) {
            return false;
        }
        TestManagedTableSource that = (TestManagedTableSource)o;
        return this.context.equals(that.context) && this.partitions.equals(that.partitions) && this.changelogMode.equals((Object)that.changelogMode);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.partitions, this.changelogMode);
    }
}

