/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.util.SimpleVersionedListState;
import org.apache.flink.streaming.runtime.operators.sink.StreamingCommitterState;
import org.apache.flink.streaming.runtime.operators.sink.StreamingCommitterStateSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

abstract class AbstractStreamingCommitterOperator<InputT, CommT>
extends AbstractStreamOperator<CommT>
implements OneInputStreamOperator<InputT, CommT> {
    private static final long serialVersionUID = 1L;
    private static final ListStateDescriptor<byte[]> STREAMING_COMMITTER_RAW_STATES_DESC = new ListStateDescriptor("streaming_committer_raw_states", (TypeSerializer)BytePrimitiveArraySerializer.INSTANCE);
    private final NavigableMap<Long, List<CommT>> committablesPerCheckpoint;
    private final StreamingCommitterStateSerializer<CommT> streamingCommitterStateSerializer;
    private ListState<StreamingCommitterState<CommT>> streamingCommitterState;
    private List<InputT> currentInputs;

    abstract void recoveredCommittables(List<CommT> var1) throws IOException;

    abstract List<CommT> prepareCommit(List<InputT> var1) throws IOException;

    abstract List<CommT> commit(List<CommT> var1) throws Exception;

    AbstractStreamingCommitterOperator(SimpleVersionedSerializer<CommT> committableSerializer) {
        this.streamingCommitterStateSerializer = new StreamingCommitterStateSerializer<CommT>(committableSerializer);
        this.committablesPerCheckpoint = new TreeMap<Long, List<CommT>>();
        this.currentInputs = new ArrayList<InputT>();
    }

    @Override
    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.streamingCommitterState = new SimpleVersionedListState<CommT>((ListState<byte[]>)context.getOperatorStateStore().getListState(STREAMING_COMMITTER_RAW_STATES_DESC), this.streamingCommitterStateSerializer);
        ArrayList restored = new ArrayList();
        ((Iterable)this.streamingCommitterState.get()).forEach(s -> restored.addAll(s.getCommittables()));
        this.recoveredCommittables(restored);
    }

    @Override
    public void processElement(StreamRecord<InputT> element) throws Exception {
        this.currentInputs.add(element.getValue());
    }

    @Override
    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.committablesPerCheckpoint.put(context.getCheckpointId(), this.prepareCommit(this.currentInputs));
        this.currentInputs = new ArrayList<InputT>();
        this.streamingCommitterState.update(Collections.singletonList(new StreamingCommitterState<CommT>(this.committablesPerCheckpoint)));
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        super.notifyCheckpointComplete(checkpointId);
        this.commitUpTo(checkpointId);
    }

    private void commitUpTo(long checkpointId) throws Exception {
        Iterator it = this.committablesPerCheckpoint.headMap(checkpointId, true).entrySet().iterator();
        ArrayList readyCommittables = new ArrayList();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            List committables = (List)entry.getValue();
            readyCommittables.addAll(committables);
            it.remove();
        }
        LOG.info("Committing the state for checkpoint {}", (Object)checkpointId);
        List neededToRetryCommittables = this.commit(readyCommittables);
        if (!neededToRetryCommittables.isEmpty()) {
            throw new UnsupportedOperationException("Currently does not support the re-commit!");
        }
        for (Object committable : readyCommittables) {
            this.output.collect(new StreamRecord(committable));
        }
    }
}

