/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.io.IOException;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.partition.consumer.CheckpointableInput;
import org.apache.flink.streaming.runtime.io.checkpointing.AlternatingWaitingForFirstBarrier;
import org.apache.flink.streaming.runtime.io.checkpointing.BarrierHandlerState;
import org.apache.flink.streaming.runtime.io.checkpointing.WaitingForFirstBarrierUnaligned;

final class CollectingBarriersUnaligned
implements BarrierHandlerState {
    private final boolean alternating;
    private final CheckpointableInput[] inputs;

    CollectingBarriersUnaligned(boolean alternating, CheckpointableInput[] inputs) {
        this.alternating = alternating;
        this.inputs = inputs;
    }

    @Override
    public BarrierHandlerState alignmentTimeout(BarrierHandlerState.Controller controller, CheckpointBarrier checkpointBarrier) {
        return this;
    }

    @Override
    public BarrierHandlerState announcementReceived(BarrierHandlerState.Controller controller, InputChannelInfo channelInfo, int sequenceNumber) throws IOException {
        this.inputs[channelInfo.getGateIdx()].convertToPriorityEvent(channelInfo.getInputChannelIdx(), sequenceNumber);
        return this;
    }

    @Override
    public BarrierHandlerState barrierReceived(BarrierHandlerState.Controller controller, InputChannelInfo channelInfo, CheckpointBarrier checkpointBarrier) throws CheckpointException, IOException {
        if (!checkpointBarrier.getCheckpointOptions().isUnalignedCheckpoint()) {
            this.inputs[channelInfo.getGateIdx()].resumeConsumption(channelInfo);
        }
        if (controller.allBarriersReceived()) {
            return this.stopCheckpoint(checkpointBarrier.getId());
        }
        return this;
    }

    @Override
    public BarrierHandlerState abort(long cancelledId) throws IOException {
        return this.stopCheckpoint(cancelledId);
    }

    private BarrierHandlerState stopCheckpoint(long cancelledId) {
        for (CheckpointableInput input : this.inputs) {
            input.checkpointStopped(cancelledId);
        }
        if (this.alternating) {
            return new AlternatingWaitingForFirstBarrier(this.inputs);
        }
        return new WaitingForFirstBarrierUnaligned(false, this.inputs);
    }
}

