/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.mongodb.source.enumerator.splitter;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public enum PartitionStrategy implements DescribedEnum
{
    SINGLE("single", (InlineElement)TextElement.text((String)"Do not split, treat a collection as a single chunk.")),
    SAMPLE("sample", (InlineElement)TextElement.text((String)"Randomly sample the collection, then splits to multiple chunks.")),
    SPLIT_VECTOR("split-vector", (InlineElement)TextElement.text((String)"Uses the SplitVector command to generate chunks for non-sharded collections.")),
    SHARDED("sharded", (InlineElement)TextElement.text((String)"Read the chunk ranges from config.chunks collection and splits to multiple chunks. Only support sharded collections.")),
    DEFAULT("default", (InlineElement)TextElement.text((String)"Using sharded strategy for sharded collections otherwise using split vector strategy."));

    private final String name;
    private final InlineElement description;

    private PartitionStrategy(String name, InlineElement description) {
        this.name = name;
        this.description = description;
    }

    public InlineElement getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }
}

