/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.connector.kafka.sink.FlinkKafkaInternalProducer;
import org.apache.flink.connector.kafka.sink.Recyclable;

class KafkaCommittable {
    private final long producerId;
    private final short epoch;
    private final String transactionalId;
    @Nullable
    private Recyclable<? extends FlinkKafkaInternalProducer<?, ?>> producer;

    public KafkaCommittable(long producerId, short epoch, String transactionalId, @Nullable Recyclable<? extends FlinkKafkaInternalProducer<?, ?>> producer) {
        this.producerId = producerId;
        this.epoch = epoch;
        this.transactionalId = transactionalId;
        this.producer = producer;
    }

    public static <K, V> KafkaCommittable of(FlinkKafkaInternalProducer<K, V> producer, Consumer<FlinkKafkaInternalProducer<K, V>> recycler) {
        return new KafkaCommittable(producer.getProducerId(), producer.getEpoch(), producer.getTransactionalId(), new Recyclable<FlinkKafkaInternalProducer<K, V>>(producer, recycler));
    }

    public long getProducerId() {
        return this.producerId;
    }

    public short getEpoch() {
        return this.epoch;
    }

    public String getTransactionalId() {
        return this.transactionalId;
    }

    public Optional<Recyclable<? extends FlinkKafkaInternalProducer<?, ?>>> getProducer() {
        return Optional.ofNullable(this.producer);
    }

    public String toString() {
        return "KafkaCommittable{producerId=" + this.producerId + ", epoch=" + this.epoch + ", transactionalId=" + this.transactionalId + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaCommittable that = (KafkaCommittable)o;
        return this.producerId == that.producerId && this.epoch == that.epoch && this.transactionalId.equals(that.transactionalId);
    }

    public int hashCode() {
        return Objects.hash(this.producerId, this.epoch, this.transactionalId);
    }
}

