/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.stream.compact;

import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;

@Internal
public interface CompactContext {
    public static CompactContext create(Configuration config, FileSystem fileSystem, String partition, Path path) {
        return new CompactContextImpl(config, fileSystem, partition, path);
    }

    public Configuration getConfig();

    public FileSystem getFileSystem();

    public String getPartition();

    public Path getPath();

    public static class CompactContextImpl
    implements CompactContext {
        private final Configuration config;
        private final FileSystem fileSystem;
        private final String partition;
        private final Path path;

        private CompactContextImpl(Configuration config, FileSystem fileSystem, String partition, Path path) {
            this.config = config;
            this.fileSystem = fileSystem;
            this.partition = partition;
            this.path = path;
        }

        @Override
        public Configuration getConfig() {
            return this.config;
        }

        @Override
        public FileSystem getFileSystem() {
            return this.fileSystem;
        }

        @Override
        public String getPartition() {
            return this.partition;
        }

        @Override
        public Path getPath() {
            return this.path;
        }
    }
}

