/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.flink.client.cli.CliArgsException;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CommandLineOptions;
import org.apache.flink.client.cli.ProgramOptionsUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;

public class ProgramOptions
extends CommandLineOptions {
    private String jarFilePath;
    protected String entryPointClass;
    private final List<URL> classpaths;
    private final String[] programArgs;
    private final int parallelism;
    private final boolean detachedMode;
    private final boolean shutdownOnAttachedExit;
    private final SavepointRestoreSettings savepointSettings;

    protected ProgramOptions(CommandLine line) throws CliArgsException {
        block8: {
            super(line);
            this.entryPointClass = line.hasOption(CliFrontendParser.CLASS_OPTION.getOpt()) ? line.getOptionValue(CliFrontendParser.CLASS_OPTION.getOpt()) : null;
            this.jarFilePath = line.hasOption(CliFrontendParser.JAR_OPTION.getOpt()) ? line.getOptionValue(CliFrontendParser.JAR_OPTION.getOpt()) : null;
            this.programArgs = this.extractProgramArgs(line);
            ArrayList<URL> classpaths = new ArrayList<URL>();
            if (line.hasOption(CliFrontendParser.CLASSPATH_OPTION.getOpt())) {
                for (String path : line.getOptionValues(CliFrontendParser.CLASSPATH_OPTION.getOpt())) {
                    try {
                        classpaths.add(new URL(path));
                    }
                    catch (MalformedURLException e) {
                        throw new CliArgsException("Bad syntax for classpath: " + path);
                    }
                }
            }
            this.classpaths = classpaths;
            if (line.hasOption(CliFrontendParser.PARALLELISM_OPTION.getOpt())) {
                String parString = line.getOptionValue(CliFrontendParser.PARALLELISM_OPTION.getOpt());
                try {
                    this.parallelism = Integer.parseInt(parString);
                    if (this.parallelism <= 0) {
                        throw new NumberFormatException();
                    }
                    break block8;
                }
                catch (NumberFormatException e) {
                    throw new CliArgsException("The parallelism must be a positive number: " + parString);
                }
            }
            this.parallelism = -1;
        }
        this.detachedMode = line.hasOption(CliFrontendParser.DETACHED_OPTION.getOpt()) || line.hasOption(CliFrontendParser.YARN_DETACHED_OPTION.getOpt());
        this.shutdownOnAttachedExit = line.hasOption(CliFrontendParser.SHUTDOWN_IF_ATTACHED_OPTION.getOpt());
        this.savepointSettings = CliFrontendParser.createSavepointRestoreSettings(line);
    }

    protected String[] extractProgramArgs(CommandLine line) {
        String[] args;
        String[] stringArray = args = line.hasOption(CliFrontendParser.ARGS_OPTION.getOpt()) ? line.getOptionValues(CliFrontendParser.ARGS_OPTION.getOpt()) : line.getArgs();
        if (args.length > 0 && !line.hasOption(CliFrontendParser.JAR_OPTION.getOpt())) {
            this.jarFilePath = args[0];
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        return args;
    }

    public void validate() throws CliArgsException {
        if (this.getJarFilePath() == null) {
            throw new CliArgsException("Java program should be specified a JAR file.");
        }
    }

    public String getJarFilePath() {
        return this.jarFilePath;
    }

    public String getEntryPointClassName() {
        return this.entryPointClass;
    }

    public List<URL> getClasspaths() {
        return this.classpaths;
    }

    public String[] getProgramArgs() {
        return this.programArgs;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public boolean getDetachedMode() {
        return this.detachedMode;
    }

    public boolean isShutdownOnAttachedExit() {
        return this.shutdownOnAttachedExit;
    }

    public SavepointRestoreSettings getSavepointRestoreSettings() {
        return this.savepointSettings;
    }

    public void applyToConfiguration(Configuration configuration) {
        if (this.getParallelism() != -1) {
            configuration.setInteger(CoreOptions.DEFAULT_PARALLELISM, this.getParallelism());
        }
        configuration.setBoolean(DeploymentOptions.ATTACHED, !this.getDetachedMode());
        configuration.setBoolean(DeploymentOptions.SHUTDOWN_IF_ATTACHED, this.isShutdownOnAttachedExit());
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.CLASSPATHS, this.getClasspaths(), URL::toString);
        SavepointRestoreSettings.toConfiguration((SavepointRestoreSettings)this.getSavepointRestoreSettings(), (Configuration)configuration);
    }

    public static ProgramOptions create(CommandLine line) throws CliArgsException {
        if (ProgramOptionsUtils.isPythonEntryPoint(line) || ProgramOptionsUtils.containsPythonDependencyOptions(line)) {
            return ProgramOptionsUtils.createPythonProgramOptions(line);
        }
        return new ProgramOptions(line);
    }
}

