/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.observability.autoconfigure;

import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;

class ObservationHandlerGrouping {
    private final List<Class<? extends ObservationHandler>> categories;

    ObservationHandlerGrouping(Class<? extends ObservationHandler> category) {
        this(Collections.singletonList(category));
    }

    ObservationHandlerGrouping(List<Class<? extends ObservationHandler>> categories) {
        this.categories = categories;
    }

    void apply(List<ObservationHandler<?>> handlers, ObservationRegistry.ObservationConfig config) {
        LinkedMultiValueMap groupings = new LinkedMultiValueMap();
        for (ObservationHandler<?> observationHandler : handlers) {
            Class<? extends ObservationHandler> category = this.findCategory(observationHandler);
            if (category != null) {
                groupings.add(category, observationHandler);
                continue;
            }
            config.observationHandler(observationHandler);
        }
        for (Class clazz : this.categories) {
            List handlerGroup = (List)groupings.get((Object)clazz);
            if (CollectionUtils.isEmpty((Collection)handlerGroup)) continue;
            config.observationHandler((ObservationHandler)new ObservationHandler.FirstMatchingCompositeObservationHandler(handlerGroup));
        }
    }

    private Class<? extends ObservationHandler> findCategory(ObservationHandler<?> handler) {
        for (Class<? extends ObservationHandler> category : this.categories) {
            if (!category.isInstance(handler)) continue;
            return category;
        }
        return null;
    }
}

