/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.profiler.Profiler;
import org.apache.dubbo.common.profiler.ProfilerEntry;
import org.apache.dubbo.common.profiler.ProfilerSwitch;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate(group={"provider"}, order=-2147483648)
public class ProfilerServerFilter
implements Filter,
BaseFilter.Listener {
    private static final String CLIENT_IP_KEY = "client_ip";
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ProfilerServerFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (ProfilerSwitch.isEnableSimpleProfiler()) {
            Object localInvokeProfiler = invocation.get("DUBBO_INVOKE_PROFILER");
            ProfilerEntry bizProfiler = localInvokeProfiler instanceof ProfilerEntry ? Profiler.enter((ProfilerEntry)((ProfilerEntry)localInvokeProfiler), (String)"Receive request. Local server invoke begin.") : Profiler.start((String)"Receive request. Server invoke begin.");
            invocation.put("DUBBO_INVOKE_PROFILER", bizProfiler);
            invocation.put(CLIENT_IP_KEY, RpcContext.getServiceContext().getRemoteAddressString());
        }
        return invoker.invoke(invocation);
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        this.afterInvoke(invoker, invocation);
        this.addAdaptiveResponse(appResponse, invocation);
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
        this.afterInvoke(invoker, invocation);
    }

    private void afterInvoke(Invoker<?> invoker, Invocation invocation) {
        Object fromInvocation;
        if (ProfilerSwitch.isEnableSimpleProfiler() && (fromInvocation = invocation.get("DUBBO_INVOKE_PROFILER")) instanceof ProfilerEntry) {
            ProfilerEntry profiler = Profiler.release((ProfilerEntry)((ProfilerEntry)fromInvocation));
            invocation.put("DUBBO_INVOKE_PROFILER", profiler);
            this.dumpIfNeed(invoker, invocation, (ProfilerEntry)fromInvocation);
        }
    }

    private void addAdaptiveResponse(Result appResponse, Invocation invocation) {
        String adaptiveLoadAttachment = invocation.getAttachment("lb_adaptive");
        if (StringUtils.isNotEmpty((String)adaptiveLoadAttachment)) {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            StringBuilder sb = new StringBuilder(64);
            sb.append("curTime:").append(System.currentTimeMillis());
            sb.append(",").append("load:").append(operatingSystemMXBean.getSystemLoadAverage() * 100.0 / (double)operatingSystemMXBean.getAvailableProcessors());
            appResponse.setAttachment("lb_adaptive", sb.toString());
        }
    }

    private void dumpIfNeed(Invoker<?> invoker, Invocation invocation, ProfilerEntry profiler) {
        long usage;
        Long timeout = RpcUtils.convertToNumber(invocation.getObjectAttachmentWithoutConvert("timeout"));
        if (timeout == null) {
            timeout = invoker.getUrl().getMethodPositiveParameter(invocation.getMethodName(), "timeout", 1000);
        }
        if ((double)(usage = profiler.getEndTime() - profiler.getStartTime()) / (1000000.0 * ProfilerSwitch.getWarnPercent()) > (double)timeout.longValue() && timeout != -1L) {
            StringBuilder attachment = new StringBuilder();
            invocation.foreachAttachment(entry -> attachment.append((String)entry.getKey()).append("=").append(entry.getValue()).append(";\n"));
            logger.warn("3-7", "", "", String.format("[Dubbo-Provider] execute service %s#%s cost %d.%06d ms, this invocation almost (maybe already) timeout. Timeout: %dms\nclient: %s\ninvocation context:\n%sthread info: \n%s", invocation.getTargetServiceUniqueName(), invocation.getMethodName(), usage / 1000000L, usage % 1000000L, timeout, invocation.get(CLIENT_IP_KEY), attachment, Profiler.buildDetail((ProfilerEntry)profiler)));
        }
    }
}

