/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.sample;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.sample.SimpleMetricsCountSampler;
import org.apache.dubbo.metrics.model.Metric;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.sample.MetricSample;

public abstract class MetricsNameCountSampler<S, K, M extends Metric>
extends SimpleMetricsCountSampler<S, K, M> {
    protected final DefaultMetricsCollector collector;
    protected final Set<K> metricNames = new ConcurrentHashSet();
    protected final MetricsCategory metricsCategory;
    protected final MetricsKey metricsKey;

    public MetricsNameCountSampler(DefaultMetricsCollector collector, MetricsCategory metricsCategory, MetricsKey metricsKey) {
        this.metricsCategory = metricsCategory;
        this.metricsKey = metricsKey;
        this.collector = collector;
        this.collector.addSampler(this);
    }

    public void addMetricName(K name) {
        this.metricNames.add(name);
    }

    @Override
    public List<MetricSample> sample() {
        ArrayList<MetricSample> metricSamples = new ArrayList<MetricSample>();
        this.metricNames.forEach(name -> this.collect(metricSamples, name));
        return metricSamples;
    }

    private void collect(List<MetricSample> samples, K metricName) {
        this.getCount(metricName).filter(e -> !e.isEmpty()).ifPresent(map -> map.forEach((k, v) -> samples.add(this.provideMetricsSample((M)k, (AtomicLong)v, this.metricsKey, this.metricsCategory))));
    }

    protected abstract MetricSample provideMetricsSample(M var1, AtomicLong var2, MetricsKey var3, MetricsCategory var4);
}

