/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.event;

import org.apache.dubbo.metrics.collector.DefaultMetricsCollector;
import org.apache.dubbo.metrics.collector.MethodMetricsCollector;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.RequestBeforeEvent;
import org.apache.dubbo.metrics.event.SimpleMetricsEventMulticaster;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.listener.AbstractMetricsKeyListener;
import org.apache.dubbo.metrics.listener.MetricsListener;
import org.apache.dubbo.metrics.model.MetricsSupport;
import org.apache.dubbo.metrics.model.key.CategoryOverall;
import org.apache.dubbo.metrics.model.key.MetricsCat;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.MetricsPlaceValue;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.RpcException;

public final class DefaultSubDispatcher
extends SimpleMetricsEventMulticaster {
    public DefaultSubDispatcher(final DefaultMetricsCollector collector) {
        CategoryOverall categoryOverall = this.initMethodRequest();
        super.addListener((MetricsListener)categoryOverall.getPost().getEventFunc().apply(collector));
        super.addListener((MetricsListener)categoryOverall.getFinish().getEventFunc().apply(collector));
        super.addListener((MetricsListener)categoryOverall.getError().getEventFunc().apply(collector));
        super.addListener((MetricsListener)new MetricsListener<RequestBeforeEvent>(){

            public boolean isSupport(MetricsEvent event) {
                return event instanceof RequestBeforeEvent;
            }

            public void onEvent(RequestBeforeEvent event) {
                MetricsPlaceValue dynamicPlaceType = MetricsPlaceValue.of((String)"consumer", (MetricsLevel)MetricsLevel.METHOD);
                MetricsSupport.increment((MetricsKey)MetricsKey.METRIC_REQUESTS_SERVICE_UNAVAILABLE_FAILED, (MetricsPlaceValue)dynamicPlaceType, (MethodMetricsCollector)collector, (MetricsEvent)event);
            }
        });
    }

    private CategoryOverall initMethodRequest() {
        return new CategoryOverall(null, new MetricsCat(MetricsKey.METRIC_REQUESTS, (key, placeType, collector) -> AbstractMetricsKeyListener.onEvent((MetricsKey)key, event -> {
            MetricsPlaceValue dynamicPlaceType = MetricsPlaceValue.of((String)((String)event.getAttachmentValue("metric_filter_side")), (MetricsLevel)MetricsLevel.METHOD);
            MetricsSupport.increment((MetricsKey)key, (MetricsPlaceValue)dynamicPlaceType, (MethodMetricsCollector)collector, (MetricsEvent)event);
            Invocation invocation = (Invocation)event.getAttachmentValue("metric_filter_invocation");
            invocation.put((Object)"metric_filter_invocation_counter", (Object)MetricSample.Type.GAUGE);
            MetricsSupport.increment((MetricsKey)MetricsKey.METRIC_REQUESTS_PROCESSING, (MetricsPlaceValue)dynamicPlaceType, (MethodMetricsCollector)collector, (MetricsEvent)event);
        })), new MetricsCat(MetricsKey.METRIC_REQUESTS_SUCCEED, (key, placeType, collector) -> AbstractMetricsKeyListener.onFinish((MetricsKey)key, event -> {
            MetricsPlaceValue dynamicPlaceType = MetricsPlaceValue.of((String)((String)event.getAttachmentValue("metric_filter_side")), (MetricsLevel)MetricsLevel.METHOD);
            MetricsSupport.dec((MetricsKey)MetricsKey.METRIC_REQUESTS_PROCESSING, (MetricsPlaceValue)dynamicPlaceType, (MethodMetricsCollector)collector, (MetricsEvent)event);
            Object throwableObj = event.getAttachmentValue("metric_filter_throwable");
            MetricsKey targetKey = throwableObj == null ? key : MetricsSupport.getMetricsKey((RpcException)((RpcException)throwableObj));
            MetricsSupport.incrAndAddRt((MetricsKey)targetKey, (MetricsPlaceValue)dynamicPlaceType, (MethodMetricsCollector)collector, (TimeCounterEvent)event);
        })), new MetricsCat(MetricsKey.METRIC_REQUEST_BUSINESS_FAILED, (key, placeType, collector) -> AbstractMetricsKeyListener.onError((MetricsKey)key, event -> {
            Throwable throwable = (Throwable)event.getAttachmentValue("metric_filter_throwable");
            MetricsKey targetKey = MetricsKey.METRIC_REQUESTS_FAILED_AGG;
            if (throwable instanceof RpcException) {
                targetKey = MetricsSupport.getMetricsKey((RpcException)((RpcException)throwable));
            }
            MetricsPlaceValue dynamicPlaceType = MetricsPlaceValue.of((String)((String)event.getAttachmentValue("metric_filter_side")), (MetricsLevel)MetricsLevel.METHOD);
            MetricsSupport.increment((MetricsKey)MetricsKey.METRIC_REQUESTS_TOTAL_FAILED, (MetricsPlaceValue)dynamicPlaceType, (MethodMetricsCollector)collector, (MetricsEvent)event);
            MetricsSupport.dec((MetricsKey)MetricsKey.METRIC_REQUESTS_PROCESSING, (MetricsPlaceValue)dynamicPlaceType, (MethodMetricsCollector)collector, (MetricsEvent)event);
            MetricsSupport.incrAndAddRt((MetricsKey)targetKey, (MetricsPlaceValue)dynamicPlaceType, (MethodMetricsCollector)collector, (TimeCounterEvent)event);
        })));
    }
}

