/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.collector.sample;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampleConfigurer;
import org.apache.dubbo.metrics.collector.sample.MetricsCountSampler;
import org.apache.dubbo.metrics.model.Metric;

public abstract class SimpleMetricsCountSampler<S, K, M extends Metric>
implements MetricsCountSampler<S, K, M> {
    private final ConcurrentMap<M, AtomicLong> EMPTY_COUNT = new ConcurrentHashMap<M, AtomicLong>();
    private final Map<K, ConcurrentMap<M, AtomicLong>> metricCounter = new ConcurrentHashMap<K, ConcurrentMap<M, AtomicLong>>();

    @Override
    public void inc(S source, K metricName) {
        this.doExecute(source, metricName, counter -> {
            counter.incrementAndGet();
            return false;
        });
    }

    @Override
    public void incOnEvent(S source, K metricName) {
        this.doExecute(source, metricName, counter -> {
            counter.incrementAndGet();
            return true;
        });
    }

    @Override
    public Optional<ConcurrentMap<M, AtomicLong>> getCount(K metricName) {
        return Optional.ofNullable(this.metricCounter.get(metricName) == null ? this.EMPTY_COUNT : this.metricCounter.get(metricName));
    }

    protected abstract void countConfigure(MetricsCountSampleConfigurer<S, K, M> var1);

    private void doExecute(S source, K metricsName, Function<AtomicLong, Boolean> counter) {
        Boolean isEvent;
        MetricsCountSampleConfigurer sampleConfigure = new MetricsCountSampleConfigurer();
        sampleConfigure.setSource(source);
        sampleConfigure.setMetricsName(metricsName);
        this.countConfigure(sampleConfigure);
        Map metricAtomic = this.metricCounter.get(metricsName);
        if (metricAtomic == null) {
            metricAtomic = this.metricCounter.computeIfAbsent(metricsName, k -> new ConcurrentHashMap());
        }
        Assert.notNull(sampleConfigure.getMetric(), (String)"metrics is null");
        AtomicLong atomicCounter = (AtomicLong)metricAtomic.get(sampleConfigure.getMetric());
        if (atomicCounter == null) {
            atomicCounter = metricAtomic.computeIfAbsent(sampleConfigure.getMetric(), k -> new AtomicLong());
        }
        if ((isEvent = counter.apply(atomicCounter)).booleanValue()) {
            sampleConfigure.getFireEventHandler().accept(sampleConfigure);
        }
    }
}

