/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.config.event;

import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.metrics.config.collector.ConfigCenterMetricsCollector;
import org.apache.dubbo.metrics.event.TimeCounterEvent;
import org.apache.dubbo.metrics.model.key.MetricsKey;
import org.apache.dubbo.metrics.model.key.MetricsLevel;
import org.apache.dubbo.metrics.model.key.TypeWrapper;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ConfigCenterEvent
extends TimeCounterEvent {
    public static final String NACOS_PROTOCOL = "nacos";
    public static final String APOLLO_PROTOCOL = "apollo";
    public static final String ZK_PROTOCOL = "zookeeper";

    public ConfigCenterEvent(ApplicationModel applicationModel, TypeWrapper typeWrapper) {
        super(applicationModel, typeWrapper);
        ScopeBeanFactory beanFactory = applicationModel.getBeanFactory();
        if (!beanFactory.isDestroyed()) {
            ConfigCenterMetricsCollector collector = (ConfigCenterMetricsCollector)((Object)beanFactory.getBean(ConfigCenterMetricsCollector.class));
            super.setAvailable(collector != null && collector.isCollectEnabled());
        }
    }

    public static ConfigCenterEvent toChangeEvent(ApplicationModel applicationModel, String key, String group, String protocol, String changeType, int count) {
        ConfigCenterEvent configCenterEvent = new ConfigCenterEvent(applicationModel, new TypeWrapper(MetricsLevel.CONFIG, MetricsKey.CONFIGCENTER_METRIC_TOTAL));
        configCenterEvent.putAttachment("configFileKey", key);
        configCenterEvent.putAttachment("configGroup", group);
        configCenterEvent.putAttachment("configProtocol", protocol);
        configCenterEvent.putAttachment("configChangeType", changeType);
        configCenterEvent.putAttachment("size", count);
        return configCenterEvent;
    }
}

