/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.AllowClassNotifyListener;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.SerializeCheckStatus;

public class SerializeSecurityManager {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SerializeSecurityManager.class);
    private final Set<String> allowedPrefix = new ConcurrentHashSet<String>();
    private final Set<String> alwaysAllowedPrefix = new ConcurrentHashSet<String>();
    private final Set<String> disAllowedPrefix = new ConcurrentHashSet<String>();
    private final Set<AllowClassNotifyListener> listeners = new ConcurrentHashSet<AllowClassNotifyListener>();
    private final Set<String> warnedClasses = new ConcurrentHashSet<String>(1);
    private volatile SerializeCheckStatus checkStatus = null;
    private volatile Boolean checkSerializable = null;

    public void addToAlwaysAllowed(String className) {
        boolean modified = this.alwaysAllowedPrefix.add(className);
        if (modified) {
            this.notifyPrefix();
        }
    }

    public void addToAllowed(String className) {
        if (this.disAllowedPrefix.stream().anyMatch(className::startsWith)) {
            return;
        }
        boolean modified = this.allowedPrefix.add(className);
        if (modified) {
            this.notifyPrefix();
        }
    }

    public void addToDisAllowed(String className) {
        String lowerCase;
        boolean modified = this.disAllowedPrefix.add(className);
        boolean bl = modified = this.allowedPrefix.removeIf(allow -> allow.startsWith(className)) || modified;
        if (modified) {
            this.notifyPrefix();
        }
        if (!Objects.equals(lowerCase = className.toLowerCase(Locale.ROOT), className)) {
            this.addToDisAllowed(lowerCase);
        }
    }

    public void setCheckStatus(SerializeCheckStatus checkStatus) {
        if (this.checkStatus == null) {
            this.checkStatus = checkStatus;
            logger.info("Serialize check level: " + checkStatus.name());
            this.notifyCheckStatus();
            return;
        }
        if (this.checkStatus.level() <= checkStatus.level()) {
            return;
        }
        this.checkStatus = checkStatus;
        logger.info("Serialize check level: " + checkStatus.name());
        this.notifyCheckStatus();
    }

    public void setCheckSerializable(boolean checkSerializable) {
        if (this.checkSerializable == null || Boolean.TRUE.equals(this.checkSerializable) && !checkSerializable) {
            this.checkSerializable = checkSerializable;
            logger.info("Serialize check serializable: " + checkSerializable);
            this.notifyCheckSerializable();
        }
    }

    public void registerListener(AllowClassNotifyListener listener) {
        this.listeners.add(listener);
        listener.notifyPrefix(this.getAllowedPrefix(), this.getDisAllowedPrefix());
        listener.notifyCheckSerializable(this.isCheckSerializable());
        listener.notifyCheckStatus(this.getCheckStatus());
    }

    private void notifyPrefix() {
        for (AllowClassNotifyListener listener : this.listeners) {
            listener.notifyPrefix(this.getAllowedPrefix(), this.getDisAllowedPrefix());
        }
    }

    private void notifyCheckStatus() {
        for (AllowClassNotifyListener listener : this.listeners) {
            listener.notifyCheckStatus(this.getCheckStatus());
        }
    }

    private void notifyCheckSerializable() {
        for (AllowClassNotifyListener listener : this.listeners) {
            listener.notifyCheckSerializable(this.isCheckSerializable());
        }
    }

    protected SerializeCheckStatus getCheckStatus() {
        return this.checkStatus == null ? AllowClassNotifyListener.DEFAULT_STATUS : this.checkStatus;
    }

    protected Set<String> getAllowedPrefix() {
        ConcurrentHashSet<String> set = new ConcurrentHashSet<String>();
        set.addAll(this.allowedPrefix);
        set.addAll(this.alwaysAllowedPrefix);
        return set;
    }

    protected Set<String> getDisAllowedPrefix() {
        ConcurrentHashSet<String> set = new ConcurrentHashSet<String>();
        set.addAll(this.disAllowedPrefix);
        return set;
    }

    protected boolean isCheckSerializable() {
        return this.checkSerializable == null || this.checkSerializable != false;
    }

    public Set<String> getWarnedClasses() {
        return this.warnedClasses;
    }
}

