/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.script;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.AbstractRouter;

public class ScriptRouter
extends AbstractRouter {
    public static final String NAME = "SCRIPT_ROUTER";
    private static final int SCRIPT_ROUTER_DEFAULT_PRIORITY = 0;
    private static final Logger logger = LoggerFactory.getLogger(ScriptRouter.class);
    private static final Map<String, ScriptEngine> ENGINES = new ConcurrentHashMap<String, ScriptEngine>();
    private final ScriptEngine engine;
    private final String rule;
    private CompiledScript function;
    private AccessControlContext accessControlContext;

    public ScriptRouter(URL url) {
        Permissions perms = new Permissions();
        perms.add(new RuntimePermission("accessDeclaredMembers"));
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), perms);
        this.accessControlContext = new AccessControlContext(new ProtectionDomain[]{domain});
        this.url = url;
        this.priority = url.getParameter("priority", 0);
        this.engine = this.getEngine(url);
        this.rule = this.getRule(url);
        try {
            Compilable compilable = (Compilable)((Object)this.engine);
            this.function = compilable.compile(this.rule);
        }
        catch (ScriptException e) {
            logger.error("route error, rule has been ignored. rule: " + this.rule + ", url: " + RpcContext.getContext().getUrl(), (Throwable)e);
        }
    }

    private String getRule(URL url) {
        String vRule = url.getParameterAndDecoded("rule");
        if (StringUtils.isEmpty((String)vRule)) {
            throw new IllegalStateException("route rule can not be empty.");
        }
        return vRule;
    }

    private ScriptEngine getEngine(URL url) {
        String type = url.getParameter("type", "javascript");
        return ENGINES.computeIfAbsent(type, t -> {
            ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName(type);
            if (scriptEngine == null) {
                throw new IllegalStateException("unsupported route engine type: " + type);
            }
            return scriptEngine;
        });
    }

    @Override
    public <T> List<Invoker<T>> route(final List<Invoker<T>> invokers, URL url, final Invocation invocation) throws RpcException {
        if (this.engine == null || this.function == null) {
            return invokers;
        }
        final Bindings bindings = this.createBindings(invokers, invocation);
        return this.getRoutedInvokers(AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return ScriptRouter.this.function.eval(bindings);
                }
                catch (ScriptException e) {
                    logger.error("route error, rule has been ignored. rule: " + ScriptRouter.this.rule + ", method:" + invocation.getMethodName() + ", url: " + RpcContext.getContext().getUrl(), (Throwable)e);
                    return invokers;
                }
            }
        }, this.accessControlContext));
    }

    protected <T> List<Invoker<T>> getRoutedInvokers(Object obj) {
        if (obj instanceof Invoker[]) {
            return Arrays.asList((Invoker[])obj);
        }
        if (obj instanceof Object[]) {
            return Arrays.stream((Object[])obj).map(item -> (Invoker)item).collect(Collectors.toList());
        }
        return (List)obj;
    }

    private <T> Bindings createBindings(List<Invoker<T>> invokers, Invocation invocation) {
        Bindings bindings = this.engine.createBindings();
        bindings.put("invokers", (Object)new ArrayList<Invoker<T>>(invokers));
        bindings.put("invocation", (Object)invocation);
        bindings.put("context", (Object)RpcContext.getContext());
        return bindings;
    }

    @Override
    public boolean isRuntime() {
        return this.url.getParameter("runtime", false);
    }

    @Override
    public boolean isForce() {
        return this.url.getParameter("force", false);
    }
}

