/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxCheckers;

import java.text.ParseException;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecificationChecker;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubtreeSpecificationSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SubtreeSpecificationSyntaxChecker.class);
    private static final long serialVersionUID = 1L;
    private SubtreeSpecificationChecker checker = new SubtreeSpecificationChecker();

    public SubtreeSpecificationSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.45");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        try {
            SubtreeSpecificationChecker subtreeSpecificationChecker = this.checker;
            synchronized (subtreeSpecificationChecker) {
                this.checker.parse(strValue);
            }
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        catch (ParseException pe) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
    }
}

