/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxCheckers;

import java.text.ParseException;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescriptionSchemaParser;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectClassDescriptionSyntaxChecker
extends SyntaxChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectClassDescriptionSyntaxChecker.class);
    private static final long serialVersionUID = 1L;
    private ObjectClassDescriptionSchemaParser schemaParser = new ObjectClassDescriptionSchemaParser();

    public ObjectClassDescriptionSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.37");
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        try {
            this.schemaParser.parseObjectClassDescription(strValue);
            LOG.debug("Syntax valid for '{}'", value);
            return true;
        }
        catch (ParseException pe) {
            LOG.debug("Syntax invalid for '{}'", value);
            return false;
        }
    }
}

