/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.parsers;

import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.LdapSyntax;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaObject;

public class ParserDescriptionUtils {
    public static boolean objectClassesMatch(ObjectClass oc0, ObjectClass oc1) throws NamingException {
        int i;
        if (!ParserDescriptionUtils.descriptionsMatch(oc0, oc1)) {
            return false;
        }
        if (oc0.getType() != oc1.getType()) {
            return false;
        }
        if (oc0.getSuperiorOids().size() != oc1.getSuperiorOids().size()) {
            return false;
        }
        for (i = 0; i < oc0.getSuperiorOids().size(); ++i) {
            if (oc0.getSuperiorOids().get(i).equals(oc1.getSuperiorOids().get(i))) continue;
            return false;
        }
        for (i = 0; i < oc0.getMustAttributeTypeOids().size(); ++i) {
            if (oc0.getMustAttributeTypeOids().get(i).equals(oc1.getMustAttributeTypeOids().get(i))) continue;
            return false;
        }
        for (i = 0; i < oc0.getMayAttributeTypeOids().size(); ++i) {
            if (oc0.getMayAttributeTypeOids().get(i).equals(oc1.getMayAttributeTypeOids().get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean attributeTypesMatch(AttributeType at0, AttributeType at1) {
        if (!ParserDescriptionUtils.descriptionsMatch(at0, at1)) {
            return false;
        }
        if (!at0.getSuperiorOid().equals(at1.getSuperiorOid())) {
            return false;
        }
        if (!at0.getEqualityOid().equals(at1.getEqualityOid())) {
            return false;
        }
        if (!at0.getSubstringOid().equals(at1.getSubstringOid())) {
            return false;
        }
        if (!at0.getOrderingOid().equals(at1.getOrderingOid())) {
            return false;
        }
        if (!at0.getSyntaxOid().equals(at1.getSyntaxOid())) {
            return false;
        }
        if (at0.getSyntaxLength() != at1.getSyntaxLength()) {
            return false;
        }
        if (at0.isSingleValued() != at1.isSingleValued()) {
            return false;
        }
        if (at0.isCollective() != at1.isCollective()) {
            return false;
        }
        if (at0.isUserModifiable() != at1.isUserModifiable()) {
            return false;
        }
        return at0.getUsage() == at1.getUsage();
    }

    public static boolean matchingRulesMatch(MatchingRule matchingRule0, MatchingRule matchingRule1) {
        if (!ParserDescriptionUtils.descriptionsMatch(matchingRule0, matchingRule1)) {
            return false;
        }
        return matchingRule0.getSyntaxOid().equals(matchingRule1.getSyntaxOid());
    }

    public static boolean syntaxesMatch(LdapSyntax ldapSyntax0, LdapSyntax ldapSyntax1) {
        return ParserDescriptionUtils.descriptionsMatch(ldapSyntax0, ldapSyntax1);
    }

    public static boolean descriptionsMatch(SchemaObject so0, SchemaObject so1) {
        if (!so0.getOid().equals(so1.getOid())) {
            return false;
        }
        if ((so0 instanceof LdapSyntax || so1 instanceof LdapSyntax) && so0.isObsolete() != so1.isObsolete()) {
            return false;
        }
        if (!so0.getDescription().equals(so1.getDescription())) {
            return false;
        }
        if (!ParserDescriptionUtils.aliasNamesMatch(so0, so1)) {
            return false;
        }
        return ParserDescriptionUtils.extensionsMatch(so0, so1);
    }

    public static boolean extensionsMatch(SchemaObject lsd0, SchemaObject lsd1) {
        if (lsd0.getExtensions().size() != lsd1.getExtensions().size()) {
            return false;
        }
        for (String key : lsd0.getExtensions().keySet()) {
            List<String> values0 = lsd0.getExtensions().get(key);
            List<String> values1 = lsd1.getExtensions().get(key);
            if (values1 == null) {
                return false;
            }
            for (int i = 0; i < values0.size(); ++i) {
                if (values0.get(i).equals(values1.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean aliasNamesMatch(SchemaObject so0, SchemaObject so1) {
        if (so0.getNames().size() != so1.getNames().size()) {
            return false;
        }
        for (int i = 0; i < so0.getNames().size(); ++i) {
            if (so0.getNames().get(i).equals(so1.getNames().get(i))) continue;
            return false;
        }
        return true;
    }
}

