/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import java.io.IOException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeValueException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.PrepareString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepTrimNormalizer
extends Normalizer {
    public static final long serialVersionUID = 1L;

    public DeepTrimNormalizer(String oid) {
        super(oid);
    }

    public DeepTrimNormalizer() {
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        try {
            String normalized = PrepareString.normalize(value.getString(), PrepareString.StringType.DIRECTORY_STRING);
            return new StringValue(normalized);
        }
        catch (IOException ioe) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err((String)"ERR_04224", (Object[])new Object[]{value}));
        }
    }

    @Override
    public String normalize(String value) throws LdapException {
        try {
            String normalized = PrepareString.normalize(value, PrepareString.StringType.DIRECTORY_STRING);
            return normalized;
        }
        catch (IOException ioe) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err((String)"ERR_04224", (Object[])new Object[]{value}));
        }
    }
}

